/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.handler;

import com.therandomlabs.randomportals.api.config.PortalType;
import com.therandomlabs.randomportals.api.config.PortalTypes;
import com.therandomlabs.randomportals.api.event.NetherPortalEvent;
import com.therandomlabs.randomportals.api.netherportal.FunctionType;
import com.therandomlabs.randomportals.api.netherportal.NetherPortal;
import com.therandomlabs.randomportals.api.netherportal.TeleportData;
import com.therandomlabs.randomportals.block.BlockNetherPortal;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class NetherPortalTeleportHandler {
    private static final Map<WeakReference<Entity>, TeleportData> preTeleportData = new HashMap<WeakReference<Entity>, TeleportData>();
    private static final Map<WeakReference<Entity>, TeleportData> teleportData = new HashMap<WeakReference<Entity>, TeleportData>();

    public static void setPortal(Entity entity, @Nullable NetherPortal portal, BlockPos pos) {
        World world = entity.func_130014_f_();
        if (portal != null && portal.getFunctionType() != FunctionType.NORMAL) {
            return;
        }
        if (!world.func_73046_m().func_71255_r()) {
            PortalType type;
            PortalType portalType = type = portal == null ? PortalTypes.getDefault(world) : portal.getType();
            if (type.destination.dimensionID == DimensionType.NETHER.func_186068_a()) {
                return;
            }
        }
        if (entity.field_71088_bW > 0) {
            entity.field_71088_bW = entity.func_82147_ab();
            return;
        }
        WeakReference<Entity> reference = null;
        boolean found = false;
        for (Map.Entry<WeakReference<Entity>, TeleportData> entry : preTeleportData.entrySet()) {
            reference = entry.getKey();
            if (reference.get() != entity) continue;
            found = true;
            break;
        }
        if (!found) {
            reference = new WeakReference<Entity>(entity);
        }
        preTeleportData.put(reference, new TeleportData(world, pos, world.func_180495_p(pos), portal));
        entity.field_181016_an = pos;
    }

    public static TeleportData getTeleportData(Entity entity) {
        for (Map.Entry<WeakReference<Entity>, TeleportData> entry : preTeleportData.entrySet()) {
            if (entry.getKey().get() != entity) continue;
            return entry.getValue();
        }
        ArrayList<WeakReference<Entity>> toRemove = new ArrayList<WeakReference<Entity>>();
        TeleportData data = null;
        for (Map.Entry<WeakReference<Entity>, TeleportData> entry : teleportData.entrySet()) {
            WeakReference<Entity> entityReference = entry.getKey();
            Entity referencedEntity = (Entity)entityReference.get();
            if (referencedEntity == null) {
                toRemove.add(entityReference);
                continue;
            }
            if (referencedEntity != entity) continue;
            data = entry.getValue();
        }
        teleportData.keySet().removeAll(toRemove);
        return data;
    }

    public static void clearTeleportData(Entity entity) {
        ArrayList<WeakReference<Entity>> toRemove = new ArrayList<WeakReference<Entity>>();
        for (Map.Entry<WeakReference<Entity>, TeleportData> entry : teleportData.entrySet()) {
            WeakReference<Entity> entityReference = entry.getKey();
            Entity referencedEntity = (Entity)entityReference.get();
            if (referencedEntity != null && referencedEntity != entity) continue;
            toRemove.add(entityReference);
        }
        teleportData.keySet().removeAll(toRemove);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (Map.Entry<WeakReference<Entity>, TeleportData> entry : preTeleportData.entrySet()) {
            WeakReference<Entity> reference = entry.getKey();
            Entity entity = (Entity)entry.getKey().get();
            if (entity == null) continue;
            NetherPortalTeleportHandler.handle(reference, entity, entry.getValue(), entity.func_130014_f_().field_73011_w.getDimension());
        }
        preTeleportData.clear();
    }

    private static void handle(WeakReference<Entity> reference, Entity entity, TeleportData data, int dimensionID) {
        if (entity.func_184218_aH()) {
            return;
        }
        PortalType type = data.getPortalType();
        IBlockState state = data.getPortalState();
        Block block = state.func_177230_c();
        int maxInPortalTime = block instanceof BlockNetherPortal ? type.teleportationDelay.getMaxInPortalTime(((BlockNetherPortal)block).getEffectiveAxis(state), entity) : entity.func_82145_z();
        if (entity.field_82153_h++ < maxInPortalTime) {
            entity.field_82153_h += 4;
            return;
        }
        entity.field_82153_h = maxInPortalTime;
        entity.field_71088_bW = entity.func_82147_ab();
        if (MinecraftForge.EVENT_BUS.post((Event)new NetherPortalEvent.Teleport.Pre(entity, data))) {
            return;
        }
        teleportData.put(reference, data);
        entity.func_184204_a(type.getDestinationDimensionID(dimensionID));
    }
}

