/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.netherportal;

import com.google.common.collect.ImmutableSet;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.block.BlockNetherPortal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class PortalBlockRegistry {
    private static final Set<Block> portalBlocks = new HashSet<Block>();

    public static ImmutableSet<Block> getBlocks() {
        return ImmutableSet.copyOf(portalBlocks);
    }

    public static void register(Block block) {
        Objects.requireNonNull(block, "block");
        portalBlocks.add(block);
    }

    public static boolean isPortal(Block block) {
        return portalBlocks.contains(block);
    }

    public static boolean isPortal(IBlockState state) {
        return PortalBlockRegistry.isPortal(state.func_177230_c());
    }

    public static boolean isPortal(World world, BlockPos pos) {
        return PortalBlockRegistry.isPortal(world.func_180495_p(pos));
    }

    public static boolean isPortal(World world, BlockPos pos, IBlockState state, FrameType type) {
        return PortalBlockRegistry.isPortal(world, pos);
    }

    public static IBlockState getState(Block block, EnumFacing.Axis axis, boolean userPlaced) {
        if (block instanceof BlockNetherPortal) {
            return block.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)axis).func_177226_a((IProperty)BlockNetherPortal.USER_PLACED, (Comparable)Boolean.valueOf(userPlaced));
        }
        IBlockState state = block.func_176223_P();
        Collection properties = state.func_177227_a();
        if (properties.contains(BlockPortal.field_176550_a)) {
            state = state.func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)axis);
        }
        if (properties.contains(BlockNetherPortal.USER_PLACED)) {
            state = state.func_177226_a((IProperty)BlockNetherPortal.USER_PLACED, (Comparable)Boolean.valueOf(userPlaced));
        }
        return state;
    }
}

