/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.netherportal;

import com.therandomlabs.randomportals.advancements.RPOCriteriaTriggers;
import com.therandomlabs.randomportals.api.config.PortalType;
import com.therandomlabs.randomportals.api.config.PortalTypeGroup;
import com.therandomlabs.randomportals.api.config.PortalTypes;
import com.therandomlabs.randomportals.api.event.NetherPortalEvent;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.netherportal.FunctionType;
import com.therandomlabs.randomportals.api.netherportal.NetherPortal;
import com.therandomlabs.randomportals.api.util.FrameStatePredicate;
import com.therandomlabs.randomportals.block.BlockNetherPortal;
import com.therandomlabs.randomportals.block.RPOBlocks;
import com.therandomlabs.randomportals.config.RPOConfig;
import com.therandomlabs.randomportals.frame.NetherPortalFrames;
import com.therandomlabs.randomportals.handler.NetherPortalActivationHandler;
import com.therandomlabs.randomportals.world.storage.RPOSavedData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class NetherPortalActivator {
    private static final Random random = new Random();
    private PortalType forcePortalType;
    private PortalType[] portalTypes;
    private boolean userCreated = true;
    private boolean activatedByFire;
    private boolean activationDelayed;
    private FunctionType functionType;
    private EntityPlayer player;

    public PortalType getForcedPortalType() {
        return this.forcePortalType;
    }

    public NetherPortalActivator forcePortalType(PortalType type) {
        this.forcePortalType = type;
        return this;
    }

    public PortalType[] getPortalTypes() {
        return this.portalTypes == null ? null : (PortalType[])this.portalTypes.clone();
    }

    public NetherPortalActivator setPortalTypes(PortalType ... portalTypes) {
        if (portalTypes.length == 0) {
            portalTypes = null;
        } else {
            for (PortalType type : portalTypes) {
                if (type != null) continue;
                throw new NullPointerException("portalTypes");
            }
        }
        if (portalTypes != null && this.forcePortalType != null) {
            throw new IllegalStateException("setPortalTypes cannot be called when forcePortalType is not null");
        }
        this.portalTypes = portalTypes;
        return this;
    }

    public boolean isUserCreated() {
        return this.userCreated;
    }

    public NetherPortalActivator setUserCreated(boolean flag) {
        this.userCreated = flag;
        return this;
    }

    public boolean isActivatedByFire() {
        return this.activatedByFire;
    }

    public NetherPortalActivator setActivatedByFire(boolean flag) {
        this.activatedByFire = flag;
        return this;
    }

    public boolean isActivationDelayed() {
        return this.activationDelayed;
    }

    public NetherPortalActivator setActivationDelayed(boolean flag) {
        this.activationDelayed = flag;
        return this;
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public NetherPortalActivator setFunctionType(FunctionType type) {
        this.functionType = type;
        return this;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public NetherPortalActivator setPlayer(EntityPlayer player) {
        this.player = player;
        return this;
    }

    public NetherPortal activate(World world, BlockPos pos, ItemStack activator) {
        return this.activate(world, pos, activator, (axis, color) -> {
            IBlockState state;
            switch (axis) {
                case X: {
                    state = ((BlockNetherPortal)Blocks.field_150427_aO).getByColor((EnumDyeColor)color).func_176223_P();
                    break;
                }
                case Y: {
                    state = RPOBlocks.purple_lateral_nether_portal.getByColor((EnumDyeColor)color).func_176223_P();
                    break;
                }
                default: {
                    state = ((BlockNetherPortal)Blocks.field_150427_aO).getByColor((EnumDyeColor)color).func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)EnumFacing.Axis.Z);
                }
            }
            return state.func_177226_a((IProperty)BlockNetherPortal.USER_PLACED, (Comparable)Boolean.valueOf(false));
        });
    }

    public NetherPortal activate(World world, BlockPos pos, ItemStack activator, IBlockState lateralPortal, IBlockState verticalXPortal, IBlockState verticalZPortal) {
        return this.activate(world, pos, activator, (axis, color) -> FrameType.get(axis, lateralPortal, verticalXPortal, verticalZPortal));
    }

    public NetherPortal activate(World world, BlockPos pos, ItemStack activator, BiFunction<EnumFacing.Axis, EnumDyeColor, IBlockState> portalBlocks) {
        if (NetherPortalActivationHandler.isDelayedActivationQueued(world, pos)) {
            return null;
        }
        FrameStatePredicate validBlocks = this.forcePortalType == null ? (this.portalTypes == null ? PortalTypes.getValidBlocks() : PortalTypes.getValidBlocks(this.portalTypes)) : PortalTypes.getValidBlocks(this.forcePortalType);
        PortalContainer portal = new PortalContainer();
        BlockPos framePos = null;
        FrameType type = FrameType.LATERAL_OR_VERTICAL;
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offset = pos.func_177972_a(facing);
            IBlockState state = world.func_180495_p(offset);
            if (!validBlocks.test(world, pos, state)) continue;
            NetherPortalFrames.EMPTY_FRAMES.detectWithCondition(world, offset, type, frame -> {
                NetherPortal result = this.testFrame((Frame)frame, offset, facing.func_176734_d(), activator);
                if (result == null) {
                    return false;
                }
                portal.portal = result;
                return true;
            });
            if (portal.portal != null) {
                framePos = offset;
                break;
            }
            if (facing != EnumFacing.DOWN && facing != EnumFacing.UP) break;
            type = FrameType.LATERAL;
        }
        if (portal.portal == null) {
            return null;
        }
        NetherPortalEvent.Activate event = new NetherPortalEvent.Activate(world, portal.portal, framePos, this.userCreated, this.activatedByFire);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return null;
        }
        NetherPortal result = event.getPortal();
        this.onActivate(world, result, pos, portalBlocks);
        return result;
    }

    protected void onActivate(World world, NetherPortal portal, BlockPos pos, BiFunction<EnumFacing.Axis, EnumDyeColor, IBlockState> portalBlocks) {
        RPOSavedData.get(world).addNetherPortal(portal, this.userCreated);
        Frame frame = portal.getFrame();
        EnumFacing.Axis axis = frame.getType().getAxis();
        EnumDyeColor[] colors = portal.getType().color.colors;
        IBlockState state = portalBlocks.apply(axis, colors[random.nextInt(colors.length)]);
        Block block = state.func_177230_c();
        Class<?> blockClass = block.getClass();
        BlockNetherPortal portalBlock = block instanceof BlockNetherPortal ? (BlockNetherPortal)block : null;
        ArrayList<BlockPos> portalPositions = new ArrayList<BlockPos>();
        for (BlockPos innerPos : frame.getInnerBlockPositions()) {
            IBlockState innerState;
            if (portalBlock != null && !RPOConfig.NetherPortals.replaceUserPlacedPortalsOnActivation && (innerState = world.func_180495_p(innerPos)).func_177230_c().getClass() == blockClass && ((Boolean)innerState.func_177229_b((IProperty)BlockNetherPortal.USER_PLACED)).booleanValue() && portalBlock.getEffectiveAxis(innerState) == axis) continue;
            portalPositions.add(innerPos);
        }
        if (this.activationDelayed) {
            NetherPortalActivationHandler.queueDelayedActivation(world, portalPositions, state);
        } else {
            for (BlockPos portalPos : portalPositions) {
                world.func_180501_a(portalPos, state, 2);
            }
        }
        PortalType portalType = portal.getType();
        SoundEvent[] sounds = portalType.activation.getActivationSoundEvents();
        if (sounds.length != 0) {
            world.func_184133_a(null, pos, sounds[world.field_73012_v.nextInt(sounds.length)], SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        }
        if (this.player != null && RPOConfig.Misc.advancements && portalType.group.toString().equals("vanilla_nether_portal")) {
            EntityPlayerMP playerMP = (EntityPlayerMP)this.player;
            RPOCriteriaTriggers.PORTALS.trigger(playerMP);
            RPOCriteriaTriggers.ACTIVATED_NETHER_PORTAL.trigger(playerMP, frame.getType(), frame.getSize());
        }
    }

    protected NetherPortal testFrame(Frame frame, BlockPos framePos, EnumFacing inwards, ItemStack activator) {
        List<PortalType> types;
        if (!frame.isFacingInwards(framePos, inwards)) {
            return null;
        }
        if (this.forcePortalType != null) {
            return new NetherPortal(frame, null, this.forcePortalType, this.functionType);
        }
        if (this.portalTypes == null) {
            int dimensionID = frame.getWorld().field_73011_w.getDimension();
            types = new ArrayList<PortalType>();
            for (PortalTypeGroup group : PortalTypes.getGroups().values()) {
                PortalType type = group.types.get(dimensionID);
                if (type == null) {
                    if (!group.canActivateInDimension(dimensionID)) continue;
                    types.add(group.getDefaultType());
                    continue;
                }
                types.add(type);
            }
        } else {
            types = Arrays.asList(this.portalTypes);
        }
        for (PortalType type : types) {
            if (this.activatedByFire && !type.activation.canBeActivatedByFire || !type.test(frame) || this.forcePortalType == null && activator != null && !type.testActivator(activator)) continue;
            return new NetherPortal(frame, null, type, this.functionType);
        }
        return null;
    }

    private static final class PortalContainer {
        NetherPortal portal;

        private PortalContainer() {
        }
    }
}

