/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.frame;

import com.therandomlabs.randomportals.api.config.FrameSize;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameSide;
import com.therandomlabs.randomportals.api.frame.FrameType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class FrameDetector {
    public static final int UNKNOWN = 0;
    public static final int CORNER = 1;
    private static final FrameSide[] SIDES = FrameSide.values();
    private final Map<BlockPos, IBlockState> posCache = new HashMap<BlockPos, IBlockState>();

    public final Frame detect(World world, BlockPos pos) {
        return this.detect(world, pos, this.getDefaultType());
    }

    public final Frame detect(World world, BlockPos pos, FrameType type) {
        return this.detect(world, pos, type, this.getDefaultSize());
    }

    public final Frame detect(World world, BlockPos pos, Function<FrameType, FrameSize> size) {
        return this.detect(world, pos, this.getDefaultType(), size);
    }

    public final Frame detect(World world, BlockPos pos, FrameType type, Function<FrameType, FrameSize> size) {
        return this.detectWithCondition(world, pos, type, size, frame -> true);
    }

    public final Frame detectWithCondition(World world, BlockPos pos, Predicate<Frame> frameCondition) {
        return this.detectWithCondition(world, pos, this.getDefaultType(), this.getDefaultSize(), frameCondition);
    }

    public final Frame detectWithCondition(World world, BlockPos pos, FrameType type, Predicate<Frame> frameCondition) {
        return this.detectWithCondition(world, pos, type, this.getDefaultSize(), frameCondition);
    }

    public final Frame detectWithCondition(World world, BlockPos pos, Function<FrameType, FrameSize> size, Predicate<Frame> frameCondition) {
        return this.detectWithCondition(world, pos, this.getDefaultType(), size, frameCondition);
    }

    public final Frame detectWithCondition(World world, BlockPos pos, FrameType type, Function<FrameType, FrameSize> size, Predicate<Frame> frameCondition) {
        Frame frame;
        IBlockState state = this.getState(world, pos);
        if (type.test(FrameType.LATERAL) && (frame = this.detect(FrameType.LATERAL, world, pos, state, size.apply(FrameType.LATERAL), frameCondition)) != null) {
            return frame;
        }
        if (type.test(FrameType.VERTICAL_X) && (frame = this.detect(FrameType.VERTICAL_X, world, pos, state, size.apply(FrameType.VERTICAL_X), frameCondition)) != null) {
            return frame;
        }
        if (type.test(FrameType.VERTICAL_Z)) {
            return this.detect(FrameType.VERTICAL_Z, world, pos, state, size.apply(FrameType.VERTICAL_Z), frameCondition);
        }
        return null;
    }

    public FrameType getDefaultType() {
        return FrameType.LATERAL_OR_VERTICAL;
    }

    public Function<FrameType, FrameSize> getDefaultSize() {
        return type -> new FrameSize();
    }

    protected abstract boolean test(World var1, FrameType var2, BlockPos var3, IBlockState var4, FrameSide var5, int var6);

    protected abstract boolean test(Frame var1);

    protected boolean testInner(World world, FrameType type, BlockPos pos, IBlockState state) {
        return true;
    }

    private Frame detect(FrameType type, World world, BlockPos pos, IBlockState state, FrameSize size, Predicate<Frame> frameCondition) {
        for (int index = 0; index < 4; ++index) {
            IBlockState checkState;
            FrameSide side = SIDES[index];
            if (!this.test(world, type, pos, state, side, 0)) continue;
            int previousIndex = index == 0 ? 3 : index - 1;
            EnumFacing facing = type.rightDownLeftUp[index];
            EnumFacing previousFacing = type.rightDownLeftUp[previousIndex].func_176734_d();
            EnumFacing opposite = facing.func_176734_d();
            FrameSide previousSide = SIDES[previousIndex];
            int maxLength = index % 2 == 0 ? size.maxWidth : size.maxHeight;
            ArrayList<BlockPos> possibleCorners = new ArrayList<BlockPos>();
            BlockPos checkPos = pos;
            int length = 1;
            do {
                ++length;
                checkPos = checkPos.func_177972_a(opposite);
                checkState = this.getState(world, checkPos);
                BlockPos checkPos2 = checkPos.func_177972_a(previousFacing);
                IBlockState checkState2 = this.getState(world, checkPos2);
                if (this.test(world, type, checkPos, checkState, side, 1) && this.test(world, type, checkPos2, checkState2, previousSide, 0)) {
                    possibleCorners.add(checkPos);
                    continue;
                }
                if (!this.testInner(world, type, checkPos2, checkState2)) break;
            } while (length != maxLength && this.test(world, type, pos, checkState, side, 0));
            if (possibleCorners.isEmpty()) continue;
            for (BlockPos possibleCorner : possibleCorners) {
                HashMap<Integer, Corner> corners = new HashMap<Integer, Corner>();
                corners.put(index, new Corner(possibleCorner, 0));
                Frame frame = this.detect(corners, type, world, possibleCorner, size.minWidth, size.maxWidth, size.minHeight, size.maxHeight, index, index, frameCondition);
                if (frame == null) continue;
                this.posCache.clear();
                return frame;
            }
        }
        this.posCache.clear();
        return null;
    }

    private Frame detect(HashMap<Integer, Corner> corners, FrameType type, World world, BlockPos pos, int minWidth, int maxWidth, int minHeight, int maxHeight, int startIndex, int index, Predicate<Frame> frameCondition) {
        IBlockState checkState;
        int maxLength;
        int minLength;
        int actualIndex = index > 3 ? index - 4 : index;
        int nextIndex = actualIndex == 3 ? 0 : actualIndex + 1;
        EnumFacing facing = type.rightDownLeftUp[actualIndex];
        EnumFacing nextFacing = type.rightDownLeftUp[nextIndex];
        FrameSide side = SIDES[actualIndex];
        FrameSide nextSide = SIDES[nextIndex];
        if (index == startIndex || index == startIndex + 1) {
            if (index % 2 == 0) {
                minLength = minWidth;
                maxLength = maxWidth;
            } else {
                minLength = minHeight;
                maxLength = maxHeight;
            }
        } else {
            Corner corner = corners.get(index == 6 ? 0 : index - 2);
            minLength = corner.sideLength;
            maxLength = corner.sideLength;
        }
        ArrayList<Tuple> possibleCorners = new ArrayList<Tuple>();
        BlockPos checkPos = pos;
        int length = 1;
        if (index != startIndex) {
            ++length;
            checkPos = checkPos.func_177972_a(facing);
        }
        do {
            checkPos = checkPos.func_177972_a(facing);
            checkState = this.getState(world, checkPos);
            BlockPos checkPos2 = checkPos.func_177972_a(nextFacing);
            IBlockState checkState2 = this.getState(world, checkPos2);
            if (++length >= minLength && this.test(world, type, pos, checkState, nextSide, 1) && this.test(world, type, checkPos2, checkState2, nextSide, 2)) {
                possibleCorners.add(new Tuple((Object)checkPos, (Object)length));
                continue;
            }
            if (!this.testInner(world, type, checkPos2, checkState2)) break;
        } while (length != maxLength && this.test(world, type, pos, checkState, side, length));
        if (possibleCorners.isEmpty()) {
            return null;
        }
        if (nextIndex == startIndex) {
            corners.get((Object)Integer.valueOf((int)actualIndex)).sideLength = (Integer)((Tuple)possibleCorners.get(0)).func_76340_b();
            Frame frame = new Frame(world, type, corners);
            return this.test(frame) && frameCondition.test(frame) ? frame : null;
        }
        for (Tuple corner : possibleCorners) {
            BlockPos cornerPos = (BlockPos)corner.func_76341_a();
            corners.get((Object)Integer.valueOf((int)actualIndex)).sideLength = (Integer)corner.func_76340_b();
            corners.put(nextIndex, new Corner(cornerPos, 0));
            Frame frame = this.detect(corners, type, world, cornerPos, minWidth, maxWidth, minHeight, maxHeight, startIndex, index + 1, frameCondition);
            if (frame == null) continue;
            return frame;
        }
        return null;
    }

    private IBlockState getState(World world, BlockPos pos) {
        return this.posCache.computeIfAbsent(pos, arg_0 -> ((World)world).func_180495_p(arg_0));
    }

    static final class Corner {
        BlockPos pos;
        int sideLength;

        Corner(BlockPos pos, int sideLength) {
            this.pos = pos;
            this.sideLength = sideLength;
        }
    }
}

