/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.config;

import com.google.common.collect.ImmutableMap;
import com.therandomlabs.randomportals.RandomPortals;
import com.therandomlabs.randomportals.api.config.FrameBlock;
import com.therandomlabs.randomportals.api.config.FrameSize;
import com.therandomlabs.randomportals.api.config.FrameSizeData;
import com.therandomlabs.randomportals.api.config.PortalActivator;
import com.therandomlabs.randomportals.api.config.PortalType;
import com.therandomlabs.randomportals.api.config.PortalTypeGroup;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.util.FrameStatePredicate;
import com.therandomlabs.randomportals.config.RPOConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public final class PortalTypes {
    public static final String VANILLA_NETHER_PORTAL_ID = "vanilla_nether_portal";
    public static final PortalTypeGroup VANILLA_NETHER_PORTAL = new PortalTypeGroup("vanilla_nether_portal");
    private static final Map<String, PortalTypeGroup> builtinGroups = new HashMap<String, PortalTypeGroup>();
    private static final Map<String, PortalTypeGroup> builtinTypes = new HashMap<String, PortalTypeGroup>();
    private static ImmutableMap<String, PortalTypeGroup> groups;
    private static FrameStatePredicate validBlocks;
    private static Predicate<ItemStack> validActivators;
    private static FrameSizeData maximumSize;

    private PortalTypes() {
    }

    public static boolean hasGroup(String id) {
        return groups.containsKey((Object)id);
    }

    public static PortalTypeGroup getGroup(String id) {
        PortalTypeGroup type = (PortalTypeGroup)groups.get((Object)id);
        return type == null ? PortalTypes.getDefaultGroup() : type;
    }

    public static PortalType get(int dimensionID, String id) {
        return PortalTypes.getGroup(id).getType(dimensionID);
    }

    public static PortalType get(World world, String id) {
        return PortalTypes.get(world.field_73011_w.getDimension(), id);
    }

    public static PortalType getSpecific(String id) {
        String[] split = StringUtils.split((String)id, (char)':');
        if (split.length == 1) {
            return PortalTypes.getGroup(id).getDefaultType();
        }
        return PortalTypes.getGroup(split[0]).getType(Integer.parseInt(split[1]));
    }

    public static PortalTypeGroup getDefaultGroup() {
        PortalTypeGroup group = (PortalTypeGroup)groups.get((Object)VANILLA_NETHER_PORTAL_ID);
        return group == null ? (PortalTypeGroup)groups.values().asList().get(0) : group;
    }

    public static PortalType getDefault(int dimensionID) {
        return PortalTypes.getDefaultGroup().getType(dimensionID);
    }

    public static PortalType getDefault(World world) {
        return PortalTypes.getDefault(world.field_73011_w.getDimension());
    }

    public static ImmutableMap<String, PortalTypeGroup> getGroups() {
        return groups;
    }

    public static FrameStatePredicate getValidBlocks() {
        return validBlocks;
    }

    public static FrameStatePredicate getValidBlocks(PortalType ... types) {
        return PortalTypes.getValidBlocks(Arrays.asList(types));
    }

    public static FrameStatePredicate getValidBlocks(Collection<PortalType> types) {
        ArrayList<Predicate<IBlockState>> matchers = new ArrayList<Predicate<IBlockState>>();
        for (PortalType type2 : types) {
            for (FrameBlock block : type2.frame.blocks) {
                matchers.add(block::test);
            }
        }
        return (world, pos, state, type) -> {
            for (Predicate matcher : matchers) {
                if (!matcher.test(state)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<ItemStack> getValidActivators() {
        return validActivators;
    }

    public static Predicate<ItemStack> getValidActivators(Collection<PortalType> types) {
        ArrayList<Predicate<ItemStack>> matchers = new ArrayList<Predicate<ItemStack>>();
        for (PortalType type : types) {
            for (PortalActivator activator : type.activation.activators) {
                matchers.add(activator::test);
            }
        }
        return stack -> {
            for (Predicate matcher : matchers) {
                if (!matcher.test(stack)) continue;
                return true;
            }
            return false;
        };
    }

    public static FrameSizeData getMaximumSize() {
        return maximumSize;
    }

    public static FrameSize getMaximumSize(FrameType type) {
        return maximumSize.get(type);
    }

    public static PortalType get(Frame frame) {
        for (PortalTypeGroup group : groups.values()) {
            for (PortalType type : group.types.values()) {
                if (!type.test(frame)) continue;
                return type;
            }
        }
        PortalTypeGroup defaultGroup = PortalTypes.getDefaultGroup();
        return defaultGroup.types.get(defaultGroup.defaultDimensionID);
    }

    public static void reload() throws IOException {
        List paths;
        Path directory = RPOConfig.getDirectory("portal_types");
        Stream<Path> pathStream = Files.list(directory);
        Iterator<Map.Entry<String, PortalTypeGroup>> iterator = null;
        try {
            paths = pathStream.collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (pathStream != null) {
                if (iterator != null) {
                    try {
                        pathStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    pathStream.close();
                }
            }
        }
        HashMap<String, PortalTypeGroup> types = new HashMap<String, PortalTypeGroup>(paths.size());
        for (Path groupPath : paths) {
            List typePaths;
            if (!Files.isDirectory(groupPath, new LinkOption[0])) {
                Files.delete(groupPath);
                continue;
            }
            String id = groupPath.getFileName().toString();
            Path groupData = groupPath.resolve("group_data.json");
            if (!Files.exists(groupData, new LinkOption[0]) || !Files.isRegularFile(groupData, new LinkOption[0])) {
                RandomPortals.LOGGER.error("Invalid portal type group: " + id);
                continue;
            }
            PortalTypeGroup group2 = RPOConfig.readJson(groupData, PortalTypeGroup.class);
            if (group2 == null) {
                RandomPortals.LOGGER.error("Invalid portal type group: " + id);
                continue;
            }
            RPOConfig.writeJson(groupData, (Object)group2);
            group2.id = id;
            try (Stream<Path> pathStream2 = Files.list(groupPath);){
                typePaths = pathStream2.collect(Collectors.toList());
            }
            for (Path typePath : typePaths) {
                int dimensionID;
                if (groupData.equals(typePath)) continue;
                if (Files.isDirectory(typePath, new LinkOption[0])) {
                    FileUtils.deleteDirectory((File)typePath.toFile());
                    continue;
                }
                String typeFileName = typePath.getFileName().toString();
                if (!typeFileName.endsWith(".json")) {
                    Files.delete(typePath);
                    continue;
                }
                try {
                    dimensionID = Integer.parseInt(StringUtils.removeEnd((String)typeFileName, (String)".json"));
                }
                catch (NumberFormatException ex) {
                    Files.delete(typePath);
                    continue;
                }
                PortalType type = RPOConfig.readJson(typePath, PortalType.class);
                if (type == null) continue;
                type.ensureCorrect();
                RPOConfig.writeJson(typePath, (Object)type);
                type.group = group2;
                type.dimensionID = dimensionID;
                group2.types.put(dimensionID, type);
            }
            if (group2.isValid()) {
                group2.ensureCorrect();
                RPOConfig.writeJson(groupData, (Object)group2);
                types.put(id, group2);
                continue;
            }
            RandomPortals.LOGGER.error("Invalid portal type group: " + id);
        }
        if (types.isEmpty() || RPOConfig.NetherPortals.forceCreateVanillaType && !types.containsKey(VANILLA_NETHER_PORTAL_ID)) {
            PortalTypes.write(directory, VANILLA_NETHER_PORTAL);
        }
        types.putAll(builtinGroups);
        for (Map.Entry<String, PortalTypeGroup> entry : builtinTypes.entrySet()) {
            String name = entry.getKey();
            if (types.containsKey(name)) continue;
            PortalTypeGroup group3 = entry.getValue();
            PortalTypes.write(directory, group3);
            types.put(name, group3);
        }
        groups = ImmutableMap.copyOf(types);
        Collection groups = types.values();
        ArrayList<PortalType> actualTypes = new ArrayList<PortalType>();
        groups.stream().map(group -> group.types.values()).forEach(actualTypes::addAll);
        validBlocks = PortalTypes.getValidBlocks(actualTypes);
        validActivators = PortalTypes.getValidActivators(actualTypes);
        maximumSize = new FrameSizeData();
        PortalTypes.maximumSize.lateral = PortalTypes.loadMaximumSize(FrameType.LATERAL);
        PortalTypes.maximumSize.verticalX = PortalTypes.loadMaximumSize(FrameType.VERTICAL_X);
        PortalTypes.maximumSize.verticalZ = PortalTypes.loadMaximumSize(FrameType.VERTICAL_Z);
    }

    public static void registerBuiltinGroup(String name, PortalTypeGroup group) {
        group.id = name;
        builtinGroups.put(name, group);
    }

    public static void unregisterBuiltinGroup(String name) {
        builtinGroups.remove(name);
    }

    public static void registerDefaultGroup(String name, PortalTypeGroup group) {
        group.id = name;
        builtinTypes.put(name, group);
    }

    public static void unregisterDefaultGroup(String name) {
        builtinTypes.remove(name);
    }

    private static void write(Path directory, PortalTypeGroup group) throws IOException {
        Path groupPath = directory.resolve(group.id);
        if (Files.exists(groupPath, new LinkOption[0])) {
            if (!Files.isDirectory(groupPath, new LinkOption[0])) {
                Files.delete(groupPath);
                Files.createDirectories(groupPath, new FileAttribute[0]);
            }
        } else {
            Files.createDirectories(groupPath, new FileAttribute[0]);
        }
        RPOConfig.writeJson(groupPath.resolve("group_data.json"), (Object)group);
        group.types.forEach((dimensionID, type) -> RPOConfig.writeJson(groupPath.resolve(dimensionID + ".json"), type));
    }

    private static FrameSize loadMaximumSize(FrameType type) {
        int minWidth = Integer.MAX_VALUE;
        int maxWidth = 3;
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = 3;
        for (PortalTypeGroup group : PortalTypes.getGroups().values()) {
            for (PortalType portalType : group.types.values()) {
                FrameSize size = portalType.frame.size.get(type);
                if (size.minWidth < minWidth) {
                    minWidth = size.minWidth;
                }
                if (size.maxWidth > maxWidth) {
                    maxWidth = size.maxWidth;
                }
                if (size.minHeight < minHeight) {
                    minHeight = size.minHeight;
                }
                if (size.maxHeight <= maxHeight) continue;
                maxHeight = size.maxHeight;
            }
        }
        return new FrameSize(minWidth, maxWidth, minHeight, maxHeight);
    }

    static {
        PortalType type = new PortalType();
        type.group = VANILLA_NETHER_PORTAL;
        type.dimensionID = 0;
        PortalTypes.VANILLA_NETHER_PORTAL.types.put(0, type);
    }
}

