/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.config;

import com.google.common.collect.Lists;
import com.therandomlabs.randomportals.api.config.FrameBlock;
import com.therandomlabs.randomportals.api.config.FrameSizeData;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.frame.RequiredCorner;
import com.therandomlabs.randomportals.util.RegistryNameAndMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class FrameData {
    public FrameType type = FrameType.LATERAL_OR_VERTICAL;
    public FrameSizeData size = new FrameSizeData();
    public List<FrameBlock> blocks = Lists.newArrayList((Object[])new FrameBlock[]{new FrameBlock(Blocks.field_150343_Z)});
    public RequiredCorner requiredCorner = RequiredCorner.ANY_NON_AIR;
    public boolean cornerBlocksContributeToMinimumAmount = true;
    public boolean doGeneratedFramesDrop = true;

    public void ensureCorrect() {
        if (this.type == FrameType.SAME) {
            this.type = FrameType.LATERAL_OR_VERTICAL;
        }
        this.size.ensureCorrect();
        ArrayList<RegistryNameAndMeta> checkedBlocks = new ArrayList<RegistryNameAndMeta>();
        for (int i = 0; i < this.blocks.size(); ++i) {
            FrameBlock block = this.blocks.get(i);
            RegistryNameAndMeta registryNameAndMeta = new RegistryNameAndMeta(block.registryName, block.meta);
            if (!block.isValid() || checkedBlocks.contains(registryNameAndMeta)) {
                this.blocks.remove(i--);
                continue;
            }
            checkedBlocks.add(registryNameAndMeta);
            block.ensureCorrect();
        }
    }

    public boolean test(Frame frame) {
        FrameType frameType = frame.getType();
        if (!this.type.test(frameType)) {
            return false;
        }
        World world = frame.getWorld();
        if (!this.size.test(frameType, frame.getWidth(), frame.getHeight())) {
            return false;
        }
        HashMap<FrameBlock, Integer> detectedBlocks = new HashMap<FrameBlock, Integer>();
        for (BlockPos pos : frame.getFrameBlockPositions()) {
            IBlockState state = world.func_180495_p(pos);
            boolean corner = frame.isCorner(pos);
            boolean found = false;
            if (corner) {
                found = this.requiredCorner.test(world, pos, state);
                if (found) {
                    if (!this.cornerBlocksContributeToMinimumAmount) {
                        continue;
                    }
                } else if (this.requiredCorner != RequiredCorner.SAME) {
                    return false;
                }
            }
            for (FrameBlock block : this.blocks) {
                if (!block.test(state)) continue;
                if (!corner || this.cornerBlocksContributeToMinimumAmount) {
                    detectedBlocks.merge(block, 1, Integer::sum);
                }
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        for (FrameBlock block : this.blocks) {
            Integer detectedAmount;
            if (block.minimumAmount == 0 || (detectedAmount = (Integer)detectedBlocks.get(block)) != null && detectedAmount >= block.minimumAmount) continue;
            return false;
        }
        return true;
    }
}

