/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.advancements;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public abstract class RPOCriterionTrigger<I extends ICriterionInstance>
implements ICriterionTrigger<I> {
    private final ResourceLocation id;
    private final Map<PlayerAdvancements, ListenerContainer> listeners = new HashMap<PlayerAdvancements, ListenerContainer>();

    public RPOCriterionTrigger(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(PlayerAdvancements advancements, ICriterionTrigger.Listener<I> listener) {
        this.listeners.computeIfAbsent(advancements, x$0 -> new ListenerContainer((PlayerAdvancements)x$0)).add(listener);
    }

    public void func_192164_b(PlayerAdvancements advancements, ICriterionTrigger.Listener<I> listener) {
        ListenerContainer container = this.listeners.get(advancements);
        if (container != null) {
            container.remove(listener);
            if (this.listeners.isEmpty()) {
                this.listeners.remove(advancements);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements advancements) {
        this.listeners.remove(advancements);
    }

    protected void trigger(EntityPlayerMP player, Predicate<I> predicate) {
        ListenerContainer container = this.listeners.get(player.func_192039_O());
        if (container != null) {
            container.trigger(predicate);
        }
    }

    public class ListenerContainer {
        private final PlayerAdvancements advancements;
        private final Set<ICriterionTrigger.Listener<I>> listeners = new HashSet();

        public ListenerContainer(PlayerAdvancements advancements) {
            this.advancements = advancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<I> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<I> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Predicate<I> predicate) {
            this.listeners.stream().filter(listener -> predicate.test(listener.func_192158_a())).collect(Collectors.toList()).forEach(listener -> listener.func_192159_a(this.advancements));
        }
    }
}

