/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.therandomlabs.randomportals.advancements.RPOCriterionTrigger;
import java.util.Locale;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;

public class DyedNetherPortalTrigger
extends RPOCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("randomportals", "dyed_nether_portal");

    protected DyedNetherPortalTrigger() {
        super(ID);
    }

    public Instance deserializeInstance(JsonObject object, JsonDeserializationContext context) {
        return new Instance(EnumDyeColor.valueOf((String)object.get("color").getAsString().toUpperCase(Locale.ROOT)), object.get("rightClickSinglePortalBlock").getAsBoolean());
    }

    public void trigger(EntityPlayerMP player, EnumDyeColor color, boolean rightClickSinglePortalBlock) {
        this.trigger(player, instance -> instance.test(color, rightClickSinglePortalBlock));
    }

    public static final class Instance
    extends AbstractCriterionInstance {
        private final EnumDyeColor color;
        private final boolean rightClickSinglePortalBlock;

        public Instance(EnumDyeColor color, boolean rightClickSinglePortalBlock) {
            super(ID);
            this.color = color;
            this.rightClickSinglePortalBlock = rightClickSinglePortalBlock;
        }

        public boolean test(EnumDyeColor color, boolean rightClickSinglePortalBlock) {
            return this.color == color && this.rightClickSinglePortalBlock == rightClickSinglePortalBlock;
        }
    }
}

