/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftblib.lib.util.IWithID;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class RayMatcher {
    public Type type = Type.BLOCK_ID;
    public String match = "";
    public final Map<String, String> properties = new HashMap<String, String>();

    public void writeData(NBTTagCompound nbt) {
        nbt.func_74778_a("match_type", this.type.getID());
        nbt.func_74778_a("match", this.match);
        if (!this.properties.isEmpty()) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                nbt1.func_74778_a(entry.getKey(), entry.getValue());
            }
            nbt.func_74782_a("properties", (NBTBase)nbt1);
        }
    }

    public void readData(NBTTagCompound nbt) {
        this.type = (Type)((Object)Type.NAME_MAP.get(nbt.func_74779_i("match_type")));
        this.match = nbt.func_74779_i("match");
        this.properties.clear();
        NBTTagCompound nbt1 = nbt.func_74775_l("properties");
        for (String s : nbt1.func_150296_c()) {
            this.properties.put(s, nbt1.func_74779_i(s));
        }
    }

    public void writeNetData(DataOut data) {
        Type.NAME_MAP.write(data, (Object)this.type);
        data.writeString(this.match);
        data.writeMap(this.properties, DataOut.STRING, DataOut.STRING);
    }

    public void readNetData(DataIn data) {
        this.type = (Type)((Object)Type.NAME_MAP.read(data));
        this.match = data.readString();
        data.readMap(this.properties, DataIn.STRING, DataIn.STRING);
    }

    public boolean stringMatches(Data data) {
        if (this.match.isEmpty()) {
            return false;
        }
        switch (this.type) {
            case BLOCK_ID: {
                return this.match.equals(data.blockId);
            }
            case BLOCK_ENTITY_ID: {
                return this.match.equals(data.blockEntityId);
            }
            case BLOCK_ENTITY_CLASS: {
                return this.match.equals(data.blockEntityClass);
            }
            case ENTITY_ID: {
                return this.match.equals(data.entityId);
            }
            case ENTITY_CLASS: {
                return this.match.equals(data.entityClass);
            }
        }
        return false;
    }

    public boolean propertiesMatch(Data data) {
        if (this.properties.isEmpty() || !this.type.block) {
            return true;
        }
        if (this.properties.size() > data.blockProperties.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String s = data.blockProperties.get(entry.getKey());
            if (s != null && s.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean matches(Data data) {
        return data != Data.EMPTY && this.stringMatches(data) && this.propertiesMatch(data);
    }

    public String getPropertyString() {
        if (this.properties.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
        return builder.toString();
    }

    public void setPropertyString(String s) {
        this.properties.clear();
        for (String s1 : s.split(",")) {
            String[] s2 = s1.split("=", 2);
            if (s2.length != 2) continue;
            this.properties.put(s2[0], s2[1]);
        }
    }

    public static class Data {
        public static final Data EMPTY = new Data();
        public final String blockId;
        public final Map<String, String> blockProperties;
        public final String blockEntityClass;
        public final String blockEntityId;
        public final String entityClass;
        public final String entityId;

        public static Data get(IBlockState state, @Nullable TileEntity tileEntity, @Nullable Entity entity) {
            if (state == BlockUtils.AIR_STATE && tileEntity == null && entity == null) {
                return EMPTY;
            }
            return new Data(state, tileEntity, entity);
        }

        public static Data get(World world, @Nullable RayTraceResult ray) {
            if (ray == null || ray.field_72313_a == RayTraceResult.Type.MISS) {
                return EMPTY;
            }
            if (ray.field_72313_a == RayTraceResult.Type.BLOCK) {
                return Data.get(world.func_180495_p(ray.func_178782_a()), world.func_175625_s(ray.func_178782_a()), ray.field_72308_g);
            }
            if (ray.field_72308_g != null) {
                return Data.get(BlockUtils.AIR_STATE, null, ray.field_72308_g);
            }
            return EMPTY;
        }

        public static Data get(EntityPlayer player) {
            return Data.get(player.field_70170_p, MathUtils.rayTrace((EntityPlayer)player, (boolean)true));
        }

        private Data() {
            this.blockId = "";
            this.blockProperties = Collections.emptyMap();
            this.blockEntityClass = "null";
            this.blockEntityId = "null";
            this.entityClass = "null";
            this.entityId = "null";
        }

        private Data(IBlockState state, @Nullable TileEntity tileEntity, @Nullable Entity entity) {
            this.blockProperties = new HashMap<String, String>();
            this.blockId = String.valueOf(state.func_177230_c().getRegistryName());
            for (Map.Entry entry : state.func_177228_b().entrySet()) {
                this.blockProperties.put(((IProperty)entry.getKey()).func_177701_a(), ((IProperty)entry.getKey()).func_177702_a((Comparable)entry.getValue()));
            }
            if (tileEntity == null) {
                this.blockEntityId = "null";
                this.blockEntityClass = "null";
            } else {
                this.blockEntityClass = tileEntity.getClass().getName();
                this.blockEntityId = String.valueOf(TileEntity.func_190559_a(tileEntity.getClass()));
            }
            if (entity == null) {
                this.entityId = "";
                this.entityClass = "";
            } else {
                this.entityClass = entity.getClass().getName();
                EntityEntry entityEntry = EntityRegistry.getEntry(entity.getClass());
                this.entityId = entityEntry == null ? "null" : String.valueOf(entityEntry.getRegistryName());
            }
        }
    }

    public static enum Type implements IWithID
    {
        BLOCK_ID("block_id", true),
        BLOCK_ENTITY_ID("block_entity_id", true),
        BLOCK_ENTITY_CLASS("block_entity_class", true),
        ENTITY_ID("entity_id", false),
        ENTITY_CLASS("entity_class", false);

        public static final NameMap<Type> NAME_MAP;
        private final String name;
        public final boolean block;

        private Type(String n2, boolean b) {
            this.name = n2;
            this.block = b;
        }

        public String getID() {
            return this.name;
        }

        static {
            NAME_MAP = NameMap.createWithBaseTranslationKey((Object)((Object)BLOCK_ID), (String)"ftbquests.raymatcher", (Object[])Type.values());
        }
    }
}

