/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.task.Task;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class FTBQuestsInventoryListener
implements IContainerListener {
    private static int detectCounter = 0;
    public final EntityPlayerMP player;

    public FTBQuestsInventoryListener(EntityPlayerMP p) {
        this.player = p;
    }

    public static void detect(EntityPlayerMP player, Collection<ItemStack> itemsToCheck) {
        detectCounter = 0;
        FTBQuestsInventoryListener.detect0(player, itemsToCheck);
    }

    private static void detect0(EntityPlayerMP player, Collection<ItemStack> itemsToCheck) {
        if (++detectCounter >= 10) {
            return;
        }
        QuestData data = ServerQuestFile.INSTANCE.getData((Entity)player);
        if (data == null) {
            return;
        }
        boolean redo = false;
        for (Chapter chapter : ServerQuestFile.INSTANCE.chapters) {
            for (Quest quest : chapter.quests) {
                if (!FTBQuestsInventoryListener.hasSubmitTasks(quest) || !quest.canStartTasks(data)) continue;
                for (Task task : quest.tasks) {
                    if (!task.submitItemsOnInventoryChange() || !data.getTaskData(task).submitTask(player, itemsToCheck, false)) continue;
                    redo = true;
                }
            }
        }
        if (redo) {
            FTBQuestsInventoryListener.detect(player, Collections.emptyList());
        }
    }

    private static boolean hasSubmitTasks(Quest quest) {
        for (Task task : quest.tasks) {
            if (!task.submitItemsOnInventoryChange()) continue;
            return true;
        }
        return false;
    }

    public void func_71110_a(Container container, NonNullList<ItemStack> itemsList) {
        FTBQuestsInventoryListener.detect(this.player, Collections.emptyList());
    }

    public void func_71111_a(Container container, int index, ItemStack stack) {
        if (!stack.func_190926_b() && container.func_75139_a((int)index).field_75224_c == this.player.field_71071_by) {
            FTBQuestsInventoryListener.detect(this.player, Collections.singleton(stack));
        }
    }

    public void func_71112_a(Container container, int id, int value) {
    }

    public void func_175173_a(Container container, IInventory inventory) {
    }
}

