/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.GuiSelectQuestObject;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ConfigQuestObject
extends ConfigValue {
    public static final String ID = "ftbquests_object";
    public final QuestFile file;
    private final IntSet validObjects;
    private int object;

    public ConfigQuestObject(QuestFile f, int o, IntSet t) {
        this.file = f;
        this.object = o;
        this.validObjects = new IntOpenHashSet((IntCollection)t);
    }

    public ConfigQuestObject(QuestFile f, int o, Predicate<QuestObjectBase> t) {
        this(f, o, (IntSet)IntSets.EMPTY_SET);
        if (t.test(null)) {
            this.validObjects.add(0);
        }
        for (QuestObjectBase objectBase : f.getAllObjects()) {
            if (!t.test(objectBase)) continue;
            this.validObjects.add(objectBase.id);
        }
    }

    public boolean isValid(int id) {
        return this.validObjects.contains(id);
    }

    public boolean isValid(@Nullable QuestObjectBase object) {
        return this.isValid(object == null ? 0 : object.id);
    }

    public String getID() {
        return ID;
    }

    public void setObject(int v) {
        this.object = v;
    }

    public int getObject() {
        return this.object;
    }

    public String getString() {
        QuestObjectBase o = this.file.getBase(this.object);
        return o == null ? "" : o.toString();
    }

    public boolean getBoolean() {
        return this.file.getBase(this.object) != null;
    }

    public int getInt() {
        return this.object;
    }

    public ConfigQuestObject copy() {
        return new ConfigQuestObject(this.file, this.object, this.validObjects);
    }

    public ITextComponent getStringForGUI() {
        QuestObjectBase o = this.file.getBase(this.object);
        if (o == null) {
            return new TextComponentString("");
        }
        return new TextComponentString(o.getUnformattedTitle());
    }

    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button, Runnable callback) {
        if (inst.getCanEdit()) {
            new GuiSelectQuestObject(this, gui, callback).openGui();
        }
    }

    public void writeData(DataOut data) {
        data.writeIntList((IntCollection)this.validObjects);
        data.writeInt(this.getInt());
    }

    public void readData(DataIn data) {
        this.validObjects.clear();
        this.validObjects.addAll((IntCollection)data.readIntList());
        int o = data.readInt();
        if (this.isValid(o)) {
            this.setObject(o);
        }
    }

    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        int o = QuestFile.getID(string);
        if (this.isValid(o)) {
            if (!simulate) {
                this.setObject(o);
            }
            return true;
        }
        return false;
    }

    public void addInfo(ConfigValueInstance inst, List<String> list) {
        QuestObjectBase o;
        if (inst.getCanEdit() && !inst.getDefaultValue().isNull()) {
            list.add(TextFormatting.AQUA + "Default: " + TextFormatting.RESET + inst.getDefaultValue().getStringForGUI().func_150254_d());
        }
        if ((o = this.file.getBase(this.object)) != null) {
            list.add(TextFormatting.AQUA + "ID: " + TextFormatting.RESET + o);
        }
    }

    public void setValueFromOtherValue(ConfigValue value) {
        int o;
        if (value instanceof ConfigQuestObject) {
            this.validObjects.clear();
            this.validObjects.addAll((IntCollection)((ConfigQuestObject)value).validObjects);
        }
        if (this.isValid(o = value.getInt())) {
            this.setObject(o);
        }
    }

    public void writeToNBT(NBTTagCompound nbt, String key) {
        nbt.func_74768_a(key, this.getObject());
    }

    public void readFromNBT(NBTTagCompound nbt, String key) {
        int o = nbt.func_74762_e(key);
        if (this.isValid(o)) {
            this.setObject(o);
        }
    }
}

