/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigTeam;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class TileWithTeam
extends TileBase {
    public String team = "";
    public boolean indestructible = false;

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        if (!this.team.isEmpty() && !type.item) {
            nbt.func_74778_a("Team", this.team);
        }
        if (this.indestructible) {
            nbt.func_74757_a("Indestructible", true);
        }
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        this.team = nbt.func_74779_i("Team");
        this.indestructible = nbt.func_74767_n("Indestructible");
        this.func_145836_u();
    }

    public final boolean isOwner(EntityPlayer player) {
        return this.team.isEmpty() || FTBLibAPI.getTeam((UUID)player.func_110124_au()).equals(this.team);
    }

    protected ConfigTeam createTeamConfig() {
        return new ConfigTeam(() -> Universe.get().getTeam(this.team), v -> {
            this.team = v.getID();
        });
    }

    public void setIDFromPlacer(EntityLivingBase placer) {
        if (this.team.isEmpty() && placer instanceof EntityPlayerMP) {
            this.team = FTBLibAPI.getTeam((UUID)placer.func_110124_au());
        }
    }
}

