/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.task.CustomTask;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.tile.IHasConfig;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TilePlayerDetector
extends TileBase
implements IHasConfig,
ITickable {
    public int task = 0;
    public boolean notifications = true;
    public double radius = 1.49;
    public double offsetY = 0.01;
    public double height = 2.98;

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        nbt.func_74768_a("task", this.task);
        nbt.func_74757_a("notifications", this.notifications);
        nbt.func_74780_a("radius", this.radius);
        nbt.func_74780_a("offset_y", this.offsetY);
        nbt.func_74780_a("height", this.height);
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        this.task = nbt.func_74762_e("task");
        this.notifications = nbt.func_74767_n("notifications");
        this.radius = nbt.func_74769_h("radius");
        this.offsetY = nbt.func_74769_h("offset_y");
        this.height = nbt.func_74769_h("height");
    }

    @Override
    public void editConfig(EntityPlayerMP player, boolean editor) {
        if (!editor) {
            return;
        }
        ConfigGroup group0 = ConfigGroup.newGroup((String)"tile");
        group0.setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.detector.player.name", new Object[0]));
        ConfigGroup config = group0.getGroup("ftbquests.detector.player");
        config.add("task", (ConfigValue)new ConfigQuestObject(ServerQuestFile.INSTANCE, this.task, CustomTask.PREDICATE){

            @Override
            public void setObject(int v) {
                TilePlayerDetector.this.task = v;
            }
        }, (ConfigValue)new ConfigQuestObject((QuestFile)ServerQuestFile.INSTANCE, 0, CustomTask.PREDICATE)).setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.detector.task", new Object[0]));
        config.addBool("notifications", () -> this.notifications, v -> {
            this.notifications = v;
        }, true).setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.detector.notifications", new Object[0]));
        config.addDouble("radius", () -> this.radius, v -> {
            this.radius = v;
        }, 1.49, 0.25, 100.0);
        config.addDouble("offset_y", () -> this.offsetY, v -> {
            this.offsetY = v;
        }, 0.01, -1000.0, 1000.0);
        config.addDouble("height", () -> this.height, v -> {
            this.height = v;
        }, 2.98, 0.1, 1000.0);
        FTBLibAPI.editServerConfig((EntityPlayerMP)player, (ConfigGroup)group0, (IConfigCallback)this);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 5L != 0L) {
            return;
        }
        Task t = ServerQuestFile.INSTANCE.getTask(this.task);
        if (t == null) {
            return;
        }
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + this.offsetY;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        AxisAlignedBB aabb = new AxisAlignedBB(x - this.radius, y, z - this.radius, x + this.radius, y + this.height, z + this.radius);
        for (EntityPlayerMP player : this.field_145850_b.func_72872_a(EntityPlayerMP.class, aabb)) {
            QuestData data;
            if (player.field_71075_bZ.field_75098_d || (data = ServerQuestFile.INSTANCE.getData((Entity)player)) == null || t.isComplete(data) || !t.quest.canStartTasks(data)) continue;
            t.forceProgress(data, ChangeProgress.COMPLETE, this.notifications);
        }
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.func_70296_d();
    }
}

