/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.net.MessageUpdateTaskProgress;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.util.ServerQuestData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class TaskData<T extends Task>
implements ICapabilityProvider,
IItemHandler {
    public final T task;
    public final QuestData data;
    public long progress = 0L;
    private boolean taskCompleted = false;

    public TaskData(T q, QuestData d) {
        this.task = q;
        this.data = d;
    }

    public final void readProgress(long p) {
        this.progress = Math.max(0L, Math.min(p, ((Task)this.task).getMaxProgress()));
        this.taskCompleted = this.isComplete();
    }

    public final void setProgress(long p) {
        if (this.progress != (p = Math.max(0L, Math.min(p, ((Task)this.task).getMaxProgress())))) {
            this.progress = p;
            this.taskCompleted = false;
            ((Task)this.task).quest.chapter.file.clearCachedProgress();
            if (!((Task)this.task).quest.chapter.file.isClient()) {
                if (ChangeProgress.sendUpdates) {
                    new MessageUpdateTaskProgress(this.data.getTeamUID(), ((Task)this.task).id, this.progress).sendToAll();
                }
                if (!this.taskCompleted && this.isComplete()) {
                    this.taskCompleted = true;
                    ArrayList<EntityPlayerMP> notifyPlayers = new ArrayList<EntityPlayerMP>();
                    if (!((Task)this.task).quest.chapter.alwaysInvisible && !((Task)this.task).quest.canRepeat && ChangeProgress.sendNotifications.get(ChangeProgress.sendUpdates)) {
                        for (ForgePlayer player : ((ServerQuestData)this.data).team.getMembers()) {
                            if (!player.isOnline()) continue;
                            notifyPlayers.add(player.getPlayer());
                        }
                    }
                    ((Task)this.task).onCompleted(this.data, notifyPlayers);
                }
            }
            this.data.markDirty();
        }
    }

    public final void addProgress(long p) {
        this.setProgress(this.progress + p);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return false;
    }

    @Nullable
    public <C> C getCapability(Capability<C> capability, @Nullable EnumFacing facing) {
        return null;
    }

    public final int getRelativeProgress() {
        long max = ((Task)this.task).getMaxProgress();
        if (max <= 0L) {
            return 0;
        }
        if (this.progress <= 0L) {
            return 0;
        }
        if (this.progress >= max) {
            return 100;
        }
        return (int)Math.max(1.0, (double)this.progress * 100.0 / (double)max);
    }

    public final boolean isComplete() {
        long max = ((Task)this.task).getMaxProgress();
        return max > 0L && this.progress >= max;
    }

    public final boolean isStarted() {
        return this.progress > 0L && ((Task)this.task).getMaxProgress() > 0L;
    }

    public String getProgressString() {
        return StringUtils.formatDouble((double)this.progress, (boolean)true);
    }

    public String toString() {
        return this.data.toString() + "#" + this.task;
    }

    public ItemStack insertItem(ItemStack stack, boolean singleItem, boolean simulate, @Nullable EntityPlayer player) {
        return stack;
    }

    public final int getSlots() {
        return 1;
    }

    public final ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public final ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (((Task)this.task).canInsertItem() && ((Task)this.task).getMaxProgress() > 0L && this.progress < ((Task)this.task).getMaxProgress() && !stack.func_190926_b()) {
            return this.insertItem(stack, false, simulate, null);
        }
        return stack;
    }

    public final ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
        if (!((Task)this.task).canInsertItem()) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack1;
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(stack1 = this.insertItem(stack, false, simulate, (EntityPlayer)player)))) continue;
            changed = true;
            if (simulate) continue;
            player.field_71071_by.field_70462_a.set(i, (Object)stack1);
        }
        return changed;
    }

    public final boolean submitTask(EntityPlayerMP player) {
        return this.submitTask(player, Collections.emptyList(), false);
    }
}

