/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StatTask
extends Task {
    public StatBase stat = StatList.field_188070_B;
    public int value = 1;

    public static StatBase get(String id) {
        for (StatBase base : StatList.field_188094_c) {
            if (!base.field_75975_e.equals(id)) continue;
            return base;
        }
        return StatList.field_188070_B;
    }

    public StatTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.STAT;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String getMaxProgressString() {
        return Integer.toString(this.value);
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("stat", this.stat.field_75975_e);
        nbt.func_74768_a("value", this.value);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.stat = StatTask.get(nbt.func_74779_i("stat"));
        this.value = nbt.func_74762_e("value");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.stat.field_75975_e);
        data.writeVarInt(this.value);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.stat = StatTask.get(data.readString());
        this.value = data.readVarInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("stat", () -> this.stat, v -> {
            this.stat = v;
        }, NameMap.createWithName((Object)StatList.field_188070_B, (sender, s) -> s.func_150951_e(), (Object[])StatList.field_188094_c.toArray(new StatBase[0])));
        config.addInt("value", () -> this.value, v -> {
            this.value = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @Override
    public String getAltTitle() {
        return this.stat.func_150951_e().func_150260_c();
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public boolean autoSubmitOnPlayerTick() {
        return true;
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<StatTask> {
        private Data(StatTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public String getProgressString() {
            return Integer.toString((int)this.progress);
        }

        @Override
        public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
            if (this.isComplete()) {
                return false;
            }
            int set = Math.min(((StatTask)this.task).value, player.func_147099_x().func_77444_a(((StatTask)this.task).stat));
            if ((long)set > this.progress) {
                if (!simulate) {
                    this.setProgress(set);
                }
                return true;
            }
            return false;
        }
    }
}

