/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DimensionTask
extends Task {
    public int dimension = -1;

    public DimensionTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.DIMENSION;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("dim", this.dimension);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.dimension = nbt.func_74762_e("dim");
        if (this.dimension == 0 && nbt.func_150297_b("dim", 8)) {
            try {
                this.dimension = DimensionType.func_193417_a((String)nbt.func_74779_i("dim")).func_186068_a();
            }
            catch (Exception ex) {
                this.dimension = -1;
            }
        }
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.dimension);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.dimension = data.readVarInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("dim", () -> this.dimension, v -> {
            this.dimension = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.ftbquests.dimension", new Object[0]));
    }

    public static String getDimensionName(int dim) {
        switch (dim) {
            case 0: {
                return I18n.func_135052_a((String)"createWorld.customize.preset.overworld", (Object[])new Object[0]);
            }
            case -1: {
                return I18n.func_135052_a((String)"advancements.nether.root.title", (Object[])new Object[0]);
            }
            case 1: {
                return I18n.func_135052_a((String)"advancements.end.root.title", (Object[])new Object[0]);
            }
        }
        for (DimensionType type : DimensionType.values()) {
            if (type.func_186068_a() != dim) continue;
            return type.func_186065_b();
        }
        return "dim_" + dim;
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.task.ftbquests.dimension", (Object[])new Object[0]) + ": " + TextFormatting.DARK_GREEN + DimensionTask.getDimensionName(this.dimension);
    }

    @Override
    public boolean autoSubmitOnPlayerTick() {
        return true;
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends BooleanTaskData<DimensionTask> {
        private Data(DimensionTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public boolean canSubmit(EntityPlayerMP player) {
            return player.field_71093_bK == ((DimensionTask)this.task).dimension && !player.func_175149_v();
        }
    }
}

