/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvancementTask
extends Task {
    public String advancement = "";

    public AdvancementTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.ADVANCEMENT;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("advancement", this.advancement);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.advancement = nbt.func_74779_i("advancement");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.advancement);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.advancement = data.readString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("advancement", () -> this.advancement, v -> {
            this.advancement = v;
        }, "").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.ftbquests.advancement", new Object[0]));
    }

    @Override
    public String getAltTitle() {
        Advancement a = Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f().func_194229_a().func_192084_a(new ResourceLocation(this.advancement));
        if (a != null && a.func_192068_c() != null) {
            return I18n.func_135052_a((String)"ftbquests.task.ftbquests.advancement", (Object[])new Object[0]) + ": " + TextFormatting.YELLOW + a.func_192068_c().func_192297_a().func_150254_d();
        }
        return super.getAltTitle();
    }

    @Override
    public Icon getAltIcon() {
        Advancement a = Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f().func_194229_a().func_192084_a(new ResourceLocation(this.advancement));
        return a == null || a.func_192068_c() == null ? super.getAltIcon() : ItemIcon.getItemIcon((ItemStack)a.func_192068_c().func_192298_b());
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public boolean autoSubmitOnPlayerTick() {
        return true;
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends BooleanTaskData<AdvancementTask> {
        private Data(AdvancementTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public boolean canSubmit(EntityPlayerMP player) {
            if (((AdvancementTask)this.task).advancement.isEmpty()) {
                return false;
            }
            Advancement a = player.field_71133_b.func_191949_aK().func_192778_a(new ResourceLocation(((AdvancementTask)this.task).advancement));
            return a != null && player.func_192039_O().func_192747_a(a).func_192105_a();
        }
    }
}

