/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RandomReward
extends Reward {
    public RewardTable table = null;

    public RandomReward(Quest parent) {
        super(parent);
    }

    @Override
    public RewardType getType() {
        return FTBQuestsRewards.RANDOM;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.getTable() != null) {
            nbt.func_74768_a("table", this.getQuestFile().rewardTables.indexOf(this.getTable()));
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        int index = nbt.func_74764_b("table") ? nbt.func_74762_e("table") : -1;
        QuestFile file = this.getQuestFile();
        if (index >= 0 && index < file.rewardTables.size()) {
            this.table = file.rewardTables.get(index);
        } else {
            this.table = new RewardTable(file);
            NBTTagList list = nbt.func_150295_c("rewards", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt1 = list.func_150305_b(i);
                Reward reward = RewardType.createReward(this.table.fakeQuest, nbt1.func_74779_i("type"));
                if (reward == null) continue;
                reward.readData(nbt1);
                this.table.rewards.add(new WeightedReward(reward, nbt1.func_74762_e("weight")));
            }
            this.table.id = file.readID(0);
            this.table.title = this.getUnformattedTitle() + " " + this.toString();
            file.rewardTables.add(this.table);
        }
    }

    @Nullable
    public RewardTable getTable() {
        if (this.table != null && this.table.invalid) {
            this.table = null;
        }
        return this.table;
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeInt(this.getTable() == null ? 0 : this.getTable().id);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.table = this.getQuestFile().getRewardTable(data.readInt());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.add("table", (ConfigValue)new ConfigQuestObject(this.getQuestFile(), RandomReward.getID(this.getTable()), QuestObjectType.REWARD_TABLE){

            @Override
            public void setObject(int object) {
                RandomReward.this.table = this.file.getRewardTable(object);
            }
        }, (ConfigValue)new ConfigQuestObject(this.getQuestFile(), 0, QuestObjectType.REWARD_TABLE)).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward_table", new Object[0]));
    }

    @Override
    public void claim(EntityPlayerMP player, boolean notify) {
        if (this.getTable() == null) {
            return;
        }
        int totalWeight = this.getTable().getTotalWeight(false);
        if (totalWeight <= 0) {
            return;
        }
        int number = player.field_70170_p.field_73012_v.nextInt(totalWeight) + 1;
        int currentWeight = 0;
        for (WeightedReward reward : this.getTable().rewards) {
            if ((currentWeight += reward.weight) < number) continue;
            reward.reward.claim(player, notify);
            return;
        }
    }

    @Override
    public Icon getAltIcon() {
        return this.getTable() == null ? super.getAltIcon() : this.getTable().getIcon();
    }

    @Override
    public String getAltTitle() {
        return this.getTable() == null ? super.getAltTitle() : (this.getTable().useTitle ? this.getTable().getTitle() : super.getAltTitle());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list) {
        if (this.getTable() != null) {
            this.getTable().addMouseOverText(list, true, false);
        }
    }

    @Override
    public boolean getExcludeFromClaimAll() {
        return false;
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.getTable() != null && this.getTable().lootCrate != null ? this.getTable().lootCrate.createStack() : null;
    }
}

