/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftbquests.gui.GuiRewardNotifications;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LootReward
extends RandomReward {
    public LootReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return FTBQuestsRewards.LOOT;
    }

    @Override
    public void claim(EntityPlayerMP player, boolean notify) {
        if (this.getTable() == null) {
            return;
        }
        int totalWeight = this.getTable().getTotalWeight(true);
        if (totalWeight <= 0) {
            return;
        }
        block0: for (int i = 0; i < this.getTable().lootSize; ++i) {
            int currentWeight = this.getTable().emptyWeight;
            int number = player.field_70170_p.field_73012_v.nextInt(totalWeight) + 1;
            if (currentWeight >= number) continue;
            for (WeightedReward reward : this.getTable().rewards) {
                if ((currentWeight += reward.weight) < number) continue;
                reward.reward.claim(player, notify);
                continue block0;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list) {
        if (this.getTable() != null) {
            this.getTable().addMouseOverText(list, true, true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(boolean canClick) {
        if (canClick) {
            new GuiRewardNotifications().openGui();
        }
        super.onButtonClicked(canClick);
    }

    @Override
    public boolean getExcludeFromClaimAll() {
        return true;
    }
}

