/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.WrappedIngredient;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.net.MessageDisplayItemRewardToast;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.latmod.mods.itemfilters.item.ItemMissing;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemReward
extends Reward {
    public ItemStack stack = new ItemStack(Items.field_151034_e);
    public int randomBonus = 0;
    public boolean onlyOne = false;

    public ItemReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return FTBQuestsRewards.ITEM;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74782_a("item", ItemMissing.write((ItemStack)this.stack, (boolean)false));
        if (this.randomBonus > 0) {
            nbt.func_74768_a("random_bonus", this.randomBonus);
        }
        if (this.onlyOne) {
            nbt.func_74757_a("only_one", true);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.stack = ItemMissing.read((NBTBase)nbt.func_74781_a("item"));
        this.randomBonus = nbt.func_74762_e("random_bonus");
        this.onlyOne = nbt.func_74767_n("only_one");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeItemStack(this.stack);
        data.writeVarInt(this.randomBonus);
        data.writeBoolean(this.onlyOne);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.stack = data.readItemStack();
        this.randomBonus = data.readVarInt();
        this.onlyOne = data.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.add("item", (ConfigValue)new ConfigItemStack.SimpleStack(() -> this.stack, v -> {
            this.stack = v;
        }), (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a)).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbquests.item", new Object[0]));
        config.addInt("random_bonus", () -> this.randomBonus, v -> {
            this.randomBonus = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.random_bonus", new Object[0]));
        config.addBool("only_one", () -> this.onlyOne, v -> {
            this.onlyOne = v;
        }, false);
    }

    @Override
    public void claim(EntityPlayerMP player, boolean notify) {
        if (this.onlyOne && player.field_71071_by.func_70431_c(this.stack)) {
            return;
        }
        ItemStack stack1 = this.stack.func_77946_l();
        stack1.func_190917_f(player.field_70170_p.field_73012_v.nextInt(this.randomBonus + 1));
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack1);
        if (notify) {
            new MessageDisplayItemRewardToast(stack1).sendTo(player);
        }
    }

    @Override
    public ItemStack claimAutomated(TileEntity tileEntity, @Nullable EntityPlayerMP player) {
        ItemStack stack1 = this.stack.func_77946_l();
        stack1.func_190917_f(tileEntity.func_145831_w().field_73012_v.nextInt(this.randomBonus + 1));
        return stack1;
    }

    @Override
    public Icon getAltIcon() {
        if (this.stack.func_190926_b()) {
            return super.getAltIcon();
        }
        return ItemIcon.getItemIcon((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)1));
    }

    @Override
    public String getAltTitle() {
        return (this.stack.func_190916_E() > 1 ? (this.randomBonus > 0 ? this.stack.func_190916_E() + "-" + (this.stack.func_190916_E() + this.randomBonus) + "x " : this.stack.func_190916_E() + "x ") : "") + this.stack.func_82833_r();
    }

    @Override
    public boolean addTitleInMouseOverText() {
        return false;
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return new WrappedIngredient((Object)this.stack).tooltip();
    }

    @Override
    public String getButtonText() {
        if (this.randomBonus > 0) {
            return this.stack.func_190916_E() + "-" + (this.stack.func_190916_E() + this.randomBonus);
        }
        return Integer.toString(this.stack.func_190916_E());
    }
}

