/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CommandReward
extends Reward {
    public String command = "/say Hi, @team!";

    public CommandReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return FTBQuestsRewards.COMMAND;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("command", this.command);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.command = nbt.func_74779_i("command");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.command);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.command = data.readString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("command", () -> this.command, v -> {
            this.command = v;
        }, "/say Hi, @team!").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbquests.command", new Object[0]));
    }

    @Override
    public void claim(EntityPlayerMP player, boolean notify) {
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        overrides.put("p", player.func_70005_c_());
        BlockPos pos = player.func_180425_c();
        overrides.put("x", pos.func_177958_n());
        overrides.put("y", pos.func_177956_o());
        overrides.put("z", pos.func_177952_p());
        Chapter chapter = this.getQuestChapter();
        if (chapter != null) {
            overrides.put("chapter", chapter);
        }
        overrides.put("quest", this.quest);
        overrides.put("team", FTBLibAPI.getTeam((UUID)player.func_110124_au()));
        String s = this.command;
        for (Map.Entry entry : overrides.entrySet()) {
            if (entry.getValue() == null) continue;
            s = s.replace("@" + (String)entry.getKey(), entry.getValue().toString());
        }
        player.field_71133_b.func_71187_D().func_71556_a((ICommandSender)player.field_71133_b, s);
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.reward.ftbquests.command", (Object[])new Object[0]) + ": " + TextFormatting.RED + this.command;
    }
}

