/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.gamestages;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GameStageTask
extends Task {
    public String stage = "";

    public GameStageTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.GAMESTAGE;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("stage", this.stage);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.stage = nbt.func_74779_i("stage");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.stage);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.stage = data.readString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("stage", () -> this.stage, v -> {
            this.stage = v;
        }, "").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.ftbquests.gamestage", new Object[0]));
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.task.ftbquests.gamestage", (Object[])new Object[0]) + ": " + TextFormatting.YELLOW + this.stage;
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends BooleanTaskData<GameStageTask> {
        private Data(GameStageTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public boolean canSubmit(EntityPlayerMP player) {
            return GameStageHelper.hasStage((EntityPlayer)player, (String)((GameStageTask)this.task).stage);
        }
    }
}

