/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.buildcraft;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.EnergyTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public class MJTask
extends EnergyTask {
    public static final ResourceLocation EMPTY_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/fe_empty.png");
    public static final ResourceLocation FULL_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/fe_full.png");

    public MJTask(Quest quest) {
        super(quest);
        this.value = 10000000000L;
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.BUILDCRAFT_MJ;
    }

    @Override
    public String getMaxProgressString() {
        return StringUtils.formatDouble((double)((double)this.value / 1000000.0), (boolean)true);
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.task.ftbquests.buildcraft_mj.text", (Object[])new Object[]{StringUtils.formatDouble((double)((double)this.value / 1000000.0), (boolean)true)});
    }

    @Override
    public void drawScreen(@Nullable TaskData data) {
        double r;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(EMPTY_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double x = -0.5;
        double y = -0.5;
        double w = 1.0;
        double h = 1.0;
        double z = 0.0;
        buffer.func_181662_b(x, y + h, z).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y + h, z).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y, z).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x, y, z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        double d = r = data == null ? 0.0 : (double)data.progress / (double)((Task)data.task).getMaxProgress();
        if (r > 0.0) {
            x -= 0.0078125;
            w += 0.015625;
            h = r * 30.0 / 32.0;
            y = 0.03125 + (1.0 - r) * 30.0 / 32.0 - 0.5;
            y -= 0.0078125;
            h += 0.015625;
            z = -0.003;
            double u0 = 0.0;
            double v0 = 0.03125 + 0.9375 * (1.0 - r);
            double u1 = 1.0;
            double v1 = 0.96875;
            mc.func_110434_K().func_110577_a(FULL_TEXTURE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(x, y + h, z).func_187315_a(u0, v1).func_181675_d();
            buffer.func_181662_b(x + w, y + h, z).func_187315_a(u1, v1).func_181675_d();
            buffer.func_181662_b(x + w, y, z).func_187315_a(u1, v0).func_181675_d();
            buffer.func_181662_b(x, y, z).func_187315_a(u0, v0).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends TaskData<MJTask>
    implements IMjReceiver {
        private Data(MJTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public String getProgressString() {
            return StringUtils.formatDouble((double)((double)this.progress / 1000000.0), (boolean)true);
        }

        @Override
        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == MjAPI.CAP_RECEIVER || capability == MjAPI.CAP_CONNECTOR;
        }

        @Override
        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == MjAPI.CAP_RECEIVER || capability == MjAPI.CAP_CONNECTOR ? this : null);
        }

        public long getPowerRequested() {
            long add = ((MJTask)this.task).value - this.progress;
            if (((MJTask)this.task).maxInput > 0L) {
                add = Math.min(add, ((MJTask)this.task).maxInput);
            }
            return add;
        }

        public long receivePower(long microJoules, boolean simulate) {
            long add;
            if (microJoules > 0L && !this.isComplete() && (add = Math.min(microJoules, this.getPowerRequested())) > 0L) {
                if (!simulate) {
                    this.addProgress(add);
                }
                return microJoules - add;
            }
            return microJoules;
        }

        public boolean canConnect(@Nonnull IMjConnector other) {
            return true;
        }
    }
}

