/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.config.IIteratingConfig;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.GuiSelectQuestObject;
import com.feed_the_beast.ftbquests.gui.tree.ButtonChapter;
import com.feed_the_beast.ftbquests.gui.tree.ButtonDummyQuest;
import com.feed_the_beast.ftbquests.gui.tree.ButtonQuest;
import com.feed_the_beast.ftbquests.gui.tree.PanelChapterHover;
import com.feed_the_beast.ftbquests.gui.tree.PanelChapters;
import com.feed_the_beast.ftbquests.gui.tree.PanelOtherButtonsBottom;
import com.feed_the_beast.ftbquests.gui.tree.PanelOtherButtonsTop;
import com.feed_the_beast.ftbquests.gui.tree.PanelQuests;
import com.feed_the_beast.ftbquests.gui.tree.PanelViewQuest;
import com.feed_the_beast.ftbquests.net.edit.MessageChangeProgress;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.net.edit.MessageMoveQuest;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class GuiQuestTree
extends GuiBase {
    public final ClientQuestFile file;
    public int scrollWidth;
    public int scrollHeight;
    public int prevMouseX;
    public int prevMouseY;
    public int grabbed;
    public Chapter selectedChapter;
    public final HashSet<Quest> selectedQuests;
    public final PanelChapters chapterPanel;
    public final PanelQuests questPanel;
    public final PanelOtherButtonsBottom otherButtonsBottomPanel;
    public final PanelOtherButtonsTop otherButtonsTopPanel;
    public final PanelChapterHover chapterHoverPanel;
    public final PanelViewQuest viewQuestPanel;
    public Color4I borderColor;
    public Color4I backgroundColor;
    public boolean movingQuest = false;
    public int zoom = 16;
    public long lastShiftPress = 0L;

    public GuiQuestTree(ClientQuestFile q) {
        this.file = q;
        this.selectedQuests = new HashSet();
        this.chapterPanel = new PanelChapters((Panel)this);
        this.selectedChapter = this.file.chapters.isEmpty() ? null : (Chapter)this.file.chapters.get(0);
        this.borderColor = Color4I.WHITE.withAlpha(88);
        this.backgroundColor = Color4I.WHITE.withAlpha(33);
        this.questPanel = new PanelQuests((Panel)this);
        this.otherButtonsBottomPanel = new PanelOtherButtonsBottom((Panel)this);
        this.otherButtonsTopPanel = new PanelOtherButtonsTop((Panel)this);
        this.chapterHoverPanel = new PanelChapterHover((Panel)this);
        this.viewQuestPanel = new PanelViewQuest(this);
        this.selectChapter(null);
    }

    @Nullable
    public Quest getViewedQuest() {
        return this.viewQuestPanel.quest;
    }

    public void addWidgets() {
        this.add((Widget)this.chapterPanel);
        this.add((Widget)this.questPanel);
        this.add((Widget)this.otherButtonsBottomPanel);
        this.add((Widget)this.otherButtonsTopPanel);
        this.add((Widget)this.chapterHoverPanel);
        this.add((Widget)this.viewQuestPanel);
    }

    public void alignWidgets() {
        this.otherButtonsBottomPanel.alignWidgets();
        this.otherButtonsTopPanel.alignWidgets();
        this.chapterPanel.alignWidgets();
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void selectChapter(@Nullable Chapter chapter) {
        if (this.selectedChapter != chapter) {
            this.movingQuest = false;
            this.closeQuest();
            this.selectedChapter = chapter;
            this.questPanel.refreshWidgets();
            this.resetScroll();
        }
    }

    public void viewQuest(Quest quest) {
        this.selectedQuests.clear();
        if (this.viewQuestPanel.quest != quest) {
            this.viewQuestPanel.quest = quest;
            this.viewQuestPanel.refreshWidgets();
        }
    }

    public boolean onClosedByKey(int key) {
        if (super.onClosedByKey(key)) {
            if (this.getViewedQuest() != null) {
                this.closeQuest();
                return false;
            }
            return true;
        }
        return false;
    }

    public void onBack() {
        if (this.getViewedQuest() != null) {
            this.closeQuest();
        } else {
            super.onBack();
        }
    }

    public void closeQuest() {
        this.selectedQuests.clear();
        if (this.viewQuestPanel.quest != null) {
            this.viewQuestPanel.quest = null;
            this.viewQuestPanel.hidePanel = false;
            this.viewQuestPanel.refreshWidgets();
        }
    }

    public void toggleSelected(Quest quest) {
        if (this.viewQuestPanel.quest != null) {
            this.viewQuestPanel.quest = null;
            this.viewQuestPanel.refreshWidgets();
        }
        if (!this.selectedQuests.add(quest)) {
            this.selectedQuests.remove(quest);
        }
    }

    public void resetScroll() {
        this.questPanel.alignWidgets();
        this.questPanel.setScrollX((this.scrollWidth - this.questPanel.width) / 2);
        this.questPanel.setScrollY((this.scrollHeight - this.questPanel.height) / 2);
    }

    public static void addObjectMenuItems(List<ContextMenuItem> contextMenu, final IOpenableGui gui, final QuestObjectBase object) {
        ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
        ConfigGroup g = object.createSubGroup(group);
        object.getConfig(g);
        if (!g.getValues().isEmpty()) {
            ArrayList<1> list = new ArrayList<1>();
            for (final ConfigValueInstance inst : g.getValues()) {
                if (!(inst.getValue() instanceof IIteratingConfig)) continue;
                String name = inst.getDisplayName().func_150254_d();
                if (!inst.getCanEdit()) {
                    name = TextFormatting.GRAY + name;
                }
                list.add(new ContextMenuItem(name, inst.getIcon(), null){

                    public void addMouseOverText(List<String> list) {
                        list.add(inst.getValue().getStringForGUI().func_150254_d());
                    }

                    public void onClicked(Panel panel, MouseButton button) {
                        inst.getValue().onClicked(gui, inst, button, () -> new MessageEditObject(object).sendToServer());
                    }

                    public void drawIcon(Theme theme, int x, int y, int w, int h) {
                        if (inst.getValue() instanceof ConfigBoolean) {
                            (inst.getValue().getBoolean() ? GuiIcons.ACCEPT : GuiIcons.ACCEPT_GRAY).draw(x, y, w, h);
                        } else {
                            super.drawIcon(theme, x, y, w, h);
                        }
                    }
                });
            }
            if (!list.isEmpty()) {
                list.sort(null);
                contextMenu.addAll(list);
                contextMenu.add(ContextMenuItem.SEPARATOR);
            }
        }
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), GuiIcons.SETTINGS, object::onEditButtonClicked));
        if (object instanceof RandomReward && !QuestObjectBase.isNull(((RandomReward)object).getTable())) {
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.reward_table.edit", (Object[])new Object[0]), GuiIcons.SETTINGS, () -> ((RandomReward)object).getTable().onEditButtonClicked()));
        }
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, () -> ClientQuestFile.INSTANCE.deleteObject(object.id)).setYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{object.getTitle()})));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.reset_progress", (Object[])new Object[0]), GuiIcons.REFRESH, () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.getTeamUID(), object.id, GuiQuestTree.isShiftKeyDown() ? ChangeProgress.RESET_DEPS : ChangeProgress.RESET).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.reset_progress_q", (Object[])new Object[0])));
        if (object instanceof QuestObject) {
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly", (Object[])new Object[0]), FTBQuestsTheme.COMPLETED, () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.getTeamUID(), object.id, GuiQuestTree.isShiftKeyDown() ? ChangeProgress.COMPLETE_DEPS : ChangeProgress.COMPLETE).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly_q", (Object[])new Object[0])));
        }
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.copy_id", (Object[])new Object[0]), GuiIcons.INFO, () -> GuiQuestTree.setClipboardString((String)QuestObjectBase.getCodeString(object))){

            public void addMouseOverText(List<String> list) {
                list.add(QuestObjectBase.getCodeString(object));
            }
        });
    }

    public static void displayError(ITextComponent error) {
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new SystemToast(SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new TextComponentTranslation("ftbquests.gui.error", new Object[0]), error));
    }

    public boolean keyPressed(int key, char keyChar) {
        if (super.keyPressed(key, keyChar)) {
            return true;
        }
        if (key == 15) {
            if (this.selectedChapter != null && this.file.chapters.size() > 1) {
                List<Chapter> visibleChapters;
                List<Chapter> list = visibleChapters = this.file.canEdit() ? this.file.chapters : this.file.getVisibleChapters(this.file.self, true);
                if (!visibleChapters.isEmpty()) {
                    this.selectChapter(visibleChapters.get(MathUtils.mod((int)(visibleChapters.indexOf(this.selectedChapter) + (GuiQuestTree.isShiftKeyDown() ? -1 : 1)), (int)visibleChapters.size())));
                }
            }
            return true;
        }
        if (keyChar >= '1' && keyChar <= '9') {
            int i = keyChar - 49;
            if (i < this.file.chapters.size()) {
                this.selectChapter((Chapter)this.file.chapters.get(i));
            }
            return true;
        }
        if (this.selectedChapter != null && this.file.canEdit() && GuiQuestTree.isCtrlKeyDown() && !GuiQuestTree.isShiftKeyDown() && !GuiQuestTree.isAltKeyDown()) {
            switch (key) {
                case 30: {
                    this.movingQuest = false;
                    this.closeQuest();
                    this.selectedQuests.addAll(this.selectedChapter.quests);
                    break;
                }
                case 32: {
                    this.movingQuest = false;
                    this.closeQuest();
                    break;
                }
                case 208: {
                    this.movingQuest = true;
                    for (Quest quest : this.selectedQuests) {
                        new MessageMoveQuest(quest.id, quest.x, (byte)(quest.y + 1)).sendToServer();
                    }
                    this.movingQuest = false;
                    break;
                }
                case 200: {
                    this.movingQuest = true;
                    for (Quest quest : this.selectedQuests) {
                        new MessageMoveQuest(quest.id, quest.x, (byte)(quest.y - 1)).sendToServer();
                    }
                    this.movingQuest = false;
                    break;
                }
                case 203: {
                    this.movingQuest = true;
                    for (Quest quest : this.selectedQuests) {
                        new MessageMoveQuest(quest.id, (byte)(quest.x - 1), quest.y).sendToServer();
                    }
                    this.movingQuest = false;
                    break;
                }
                case 205: {
                    this.movingQuest = true;
                    for (Quest quest : this.selectedQuests) {
                        new MessageMoveQuest(quest.id, (byte)(quest.x + 1), quest.y).sendToServer();
                    }
                    this.movingQuest = false;
                }
            }
            return true;
        }
        if (key == 42) {
            long now = System.currentTimeMillis();
            if (this.lastShiftPress == 0L) {
                this.lastShiftPress = now;
            } else {
                if (now - this.lastShiftPress <= 400L) {
                    ConfigQuestObject c = new ConfigQuestObject((QuestFile)this.file, 0, QuestObjectType.CHAPTER.or(QuestObjectType.QUEST));
                    GuiSelectQuestObject gui = new GuiSelectQuestObject(c, (IOpenableGui)this, () -> {
                        QuestObjectBase o = this.file.getBase(c.getObject());
                        if (o instanceof Chapter) {
                            this.selectChapter((Chapter)o);
                        } else if (o instanceof Quest) {
                            this.zoom = 20;
                            this.selectChapter(((Quest)o).chapter);
                            this.viewQuestPanel.hidePanel = false;
                            this.viewQuest((Quest)o);
                        }
                    });
                    gui.focus();
                    gui.setTitle(I18n.func_135052_a((String)"gui.search_box", (Object[])new Object[0]));
                    gui.openGui();
                }
                this.lastShiftPress = 0L;
            }
        }
        return false;
    }

    public void tick() {
        List<Chapter> visible;
        if (this.selectedChapter != null && this.selectedChapter.invalid) {
            this.selectChapter(null);
        }
        if (this.selectedChapter == null && !(visible = this.file.getVisibleChapters(this.file.self, !this.file.canEdit())).isEmpty()) {
            this.selectChapter(visible.get(0));
        }
        super.tick();
    }

    public int getZoom() {
        return this.zoom;
    }

    public void addZoom(int up) {
        int z = this.zoom;
        this.zoom = MathHelper.func_76125_a((int)(this.zoom + up * 4), (int)8, (int)24);
        if (this.zoom != z) {
            this.grabbed = 0;
            this.resetScroll();
        }
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        super.drawBackground(theme, x, y, w, h);
        int pw = 20;
        this.borderColor.draw(x + pw - 1, y + 1, 1, h - 2);
        this.backgroundColor.draw(x + 1, y + 1, pw - 2, h - 2);
        this.borderColor.draw(x + w - pw, y + 1, 1, h - 2);
        this.backgroundColor.draw(x + w - pw + 1, y + 1, pw - 2, h - 2);
        if (this.grabbed != 0) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.scrollWidth > this.questPanel.width) {
                this.questPanel.setScrollX(Math.max(Math.min(this.questPanel.getScrollX() + (this.prevMouseX - mx), this.scrollWidth - this.questPanel.width), 0));
            } else {
                this.questPanel.setScrollX((this.scrollWidth - this.questPanel.width) / 2);
            }
            if (this.scrollHeight > this.questPanel.height) {
                this.questPanel.setScrollY(Math.max(Math.min(this.questPanel.getScrollY() + (this.prevMouseY - my), this.scrollHeight - this.questPanel.height), 0));
            } else {
                this.questPanel.setScrollY((this.scrollHeight - this.questPanel.height) / 2);
            }
            this.prevMouseX = mx;
            this.prevMouseY = my;
        }
    }

    public void drawForeground(Theme theme, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect((int)x, (int)y, (int)w, (int)h, (Color4I)this.borderColor, (boolean)false);
        if (this.file.canEdit()) {
            for (Widget widget : this.questPanel.widgets) {
                if (!widget.isMouseOver()) continue;
                if (widget instanceof ButtonQuest) {
                    theme.pushFontUnicode(true);
                    theme.drawString("X: " + ((ButtonQuest)widget).quest.x, x + 22, y + h - 18);
                    theme.drawString("Y: " + ((ButtonQuest)widget).quest.y, x + 22, y + h - 10);
                    theme.popFontUnicode();
                    break;
                }
                if (!(widget instanceof ButtonDummyQuest)) continue;
                theme.pushFontUnicode(true);
                theme.drawString("X: " + ((ButtonDummyQuest)widget).x, x + 22, y + h - 18);
                theme.drawString("Y: " + ((ButtonDummyQuest)widget).y, x + 22, y + h - 10);
                theme.popFontUnicode();
                break;
            }
        }
        super.drawForeground(theme, x, y, w, h);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public boolean drawDefaultBackground() {
        return false;
    }

    public void open(@Nullable QuestObject object) {
        Chapter c;
        Chapter chapter = c = this.chapterHoverPanel.chapter == null ? null : this.chapterHoverPanel.chapter.chapter;
        if (object instanceof Chapter) {
            this.selectChapter((Chapter)object);
        } else if (object instanceof Quest) {
            this.viewQuestPanel.hidePanel = false;
            this.selectChapter(((Quest)object).chapter);
            this.viewQuest((Quest)object);
        } else if (object instanceof Task) {
            this.viewQuestPanel.hidePanel = false;
            this.selectChapter(((Task)object).quest.chapter);
            this.viewQuest(((Task)object).quest);
        }
        this.openGui();
        if (c != null) {
            for (Widget widget : this.chapterPanel.widgets) {
                if (!(widget instanceof ButtonChapter) || c != ((ButtonChapter)widget).chapter) continue;
                this.chapterHoverPanel.chapter = (ButtonChapter)widget;
                this.chapterHoverPanel.refreshWidgets();
                this.chapterHoverPanel.updateMouseOver(this.getMouseX(), this.getMouseY());
                break;
            }
        }
    }

    public boolean handleClick(String scheme, String path) {
        if (scheme.isEmpty() && path.startsWith("#")) {
            this.open(this.file.get(QuestFile.getID(path)));
            return true;
        }
        return super.handleClick(scheme, path);
    }
}

