/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;

public class ButtonTask
extends Button {
    public final GuiQuestTree treeGui;
    public Task task;

    public ButtonTask(Panel panel, Task t) {
        super(panel, t.getTitle(), GuiIcons.ACCEPT);
        this.treeGui = (GuiQuestTree)panel.getGui();
        this.task = t;
        this.setSize(18, 18);
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            this.task.onButtonClicked(!this.task.invalid && this.treeGui.file.self != null && this.task.quest.canStartTasks(this.treeGui.file.self) && !this.task.isComplete(this.treeGui.file.self));
        } else if (button.isRight() && this.treeGui.file.canEdit()) {
            GuiHelper.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            GuiQuestTree.addObjectMenuItems(contextMenu, (IOpenableGui)this.getGui(), this.task);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.task.getIngredient();
    }

    public void addMouseOverText(List<String> list) {
        TaskData data;
        if (ButtonTask.isShiftKeyDown() && ButtonTask.isCtrlKeyDown()) {
            list.add(TextFormatting.DARK_GRAY + this.task.toString());
        }
        if (this.task.addTitleInMouseOverText()) {
            list.add(this.getTitle());
        }
        if (this.treeGui.file.self != null && this.task.quest.canStartTasks(this.treeGui.file.self)) {
            data = this.treeGui.file.self.getTaskData(this.task);
            long maxp = this.task.getMaxProgress();
            if (maxp > 1L) {
                if (this.task.hideProgressNumbers()) {
                    list.add(TextFormatting.DARK_GREEN + "[" + data.getRelativeProgress() + "%]");
                } else {
                    String prog;
                    String max = ButtonTask.isShiftKeyDown() ? Long.toUnsignedString(maxp) : this.task.getMaxProgressString();
                    String string = prog = ButtonTask.isShiftKeyDown() ? Long.toUnsignedString(data.progress) : data.getProgressString();
                    if (maxp < 100L) {
                        list.add(TextFormatting.DARK_GREEN + (data.progress > maxp ? max : prog) + " / " + max);
                    } else {
                        list.add(TextFormatting.DARK_GREEN + (data.progress > maxp ? max : prog) + " / " + max + TextFormatting.DARK_GRAY + " [" + data.getRelativeProgress() + "%]");
                    }
                }
            }
        } else {
            data = null;
        }
        this.task.addMouseOverText(list, data);
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(theme, x, y, w, h);
        }
    }

    public void drawIcon(Theme theme, int x, int y, int w, int h) {
        this.task.drawGUI(this.treeGui.file.self == null ? null : this.treeGui.file.self.getTaskData(this.task), x, y, w, h);
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        super.draw(theme, x, y, w, h);
        if (this.treeGui.file.self != null && this.task.isComplete(this.treeGui.file.self)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            FTBQuestsTheme.COMPLETED.draw(x + w - 9, y + 1, 8, 8);
            GlStateManager.func_179121_F();
        } else {
            String s = this.task.getButtonText();
            if (!s.isEmpty()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)x + 19.0f - (float)theme.getStringWidth(s) / 2.0f), (float)((float)y + 15.0f), (float)500.0f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
                theme.drawString(s, 0, 0, Color4I.WHITE, 2);
                GlStateManager.func_179121_F();
            }
        }
    }
}

