/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateObject;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ButtonQuest
extends Button {
    public static final Color4I COL_COMPLETED = Color4I.rgb((int)0x56FF56);
    public static final Color4I COL_STARTED = Color4I.rgb((int)65535);
    public GuiQuestTree treeGui;
    public Quest quest;
    public List<ButtonQuest> dependencies = null;

    public ButtonQuest(Panel panel, Quest q) {
        super(panel, q.getTitle(), q.getIcon());
        this.treeGui = (GuiQuestTree)panel.getGui();
        this.setSize(20, 20);
        this.quest = q;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.treeGui.viewQuestPanel.isMouseOver() || this.treeGui.chapterHoverPanel.isMouseOverAnyWidget()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public List<ButtonQuest> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<ButtonQuest>();
            for (QuestObject dependency : this.quest.dependencies) {
                if (dependency.invalid || !(dependency instanceof Quest)) continue;
                for (Widget widget : this.treeGui.questPanel.widgets) {
                    if (!(widget instanceof ButtonQuest) || dependency != ((ButtonQuest)widget).quest) continue;
                    this.dependencies.add((ButtonQuest)widget);
                }
            }
            this.dependencies = this.dependencies.isEmpty() ? Collections.emptyList() : this.dependencies;
        }
        return this.dependencies;
    }

    public void onClicked(MouseButton button) {
        Quest selectedQuest;
        GuiHelper.playClickSound();
        Quest quest = selectedQuest = this.treeGui.selectedQuests.size() == 1 ? this.treeGui.selectedQuests.iterator().next() : null;
        if (this.treeGui.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            if (this.treeGui.selectedQuests.size() > 1) {
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.add_reward_all", (Object[])new Object[0]), FTBQuestsTheme.ADD, () -> {
                    ArrayList<ContextMenuItem> contextMenu2 = new ArrayList<ContextMenuItem>();
                    for (RewardType type : RewardType.getRegistry()) {
                        contextMenu2.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                            GuiHelper.playClickSound();
                            type.getGuiProvider().openCreationGui((IOpenableGui)this, this.quest, reward -> {
                                for (Quest quest1 : this.treeGui.selectedQuests) {
                                    Reward r = type.provider.create(quest1);
                                    NBTTagCompound nbt1 = new NBTTagCompound();
                                    reward.writeData(nbt1);
                                    r.readData(nbt1);
                                    NBTTagCompound extra = new NBTTagCompound();
                                    extra.func_74778_a("type", type.getTypeForNBT());
                                    new MessageCreateObject(r, extra).sendToServer();
                                }
                            });
                        }));
                    }
                    this.getGui().openContextMenu(contextMenu2);
                }));
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, () -> {
                    this.treeGui.selectedQuests.forEach(q -> ClientQuestFile.INSTANCE.deleteObject(q.id));
                    this.treeGui.closeQuest();
                }).setYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{I18n.func_135052_a((String)"ftbquests.quests", (Object[])new Object[0]) + " [" + this.treeGui.selectedQuests.size() + "]"})));
            } else {
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), GuiIcons.UP, () -> {
                    this.treeGui.movingQuest = true;
                    this.treeGui.selectedQuests.clear();
                    this.treeGui.toggleSelected(this.quest);
                }));
                if (selectedQuest != null && selectedQuest != this.quest) {
                    if (selectedQuest.hasDependency(this.quest)) {
                        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.rem_dep", (Object[])new Object[0]), GuiIcons.REMOVE, () -> this.editDependency(selectedQuest, this.quest, false)));
                    } else if (this.quest.hasDependency(selectedQuest)) {
                        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.rem_dep", (Object[])new Object[0]), GuiIcons.REMOVE, () -> this.editDependency(this.quest, selectedQuest, false)));
                    } else {
                        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.set_dep", (Object[])new Object[0]), FTBQuestsTheme.ADD, () -> this.editDependency(this.quest, selectedQuest, true)).setEnabled(selectedQuest != null && selectedQuest != this.quest && !selectedQuest.canRepeat));
                    }
                }
                contextMenu.add(ContextMenuItem.SEPARATOR);
                GuiQuestTree.addObjectMenuItems(contextMenu, (IOpenableGui)this.getGui(), this.quest);
            }
            this.getGui().openContextMenu(contextMenu);
        } else if (button.isLeft()) {
            if (this.treeGui.movingQuest && selectedQuest == this.quest) {
                this.treeGui.movingQuest = false;
                this.treeGui.viewQuestPanel.hidePanel = false;
                this.treeGui.viewQuest(this.quest);
            } else if (ButtonQuest.isCtrlKeyDown() && this.treeGui.file.canEdit()) {
                if (this.treeGui.getViewedQuest() != null) {
                    this.treeGui.closeQuest();
                }
                this.treeGui.toggleSelected(this.quest);
            } else if (!this.quest.guidePage.isEmpty() && this.quest.tasks.isEmpty() && this.quest.rewards.isEmpty() && this.quest.getText().length == 0) {
                this.handleClick("guide", this.quest.guidePage);
            } else if (this.quest.customClick.isEmpty() || !this.handleClick(this.quest.customClick)) {
                this.treeGui.open(this.quest);
            }
        } else if (this.treeGui.file.canEdit() && button.isMiddle()) {
            this.treeGui.movingQuest = true;
            this.treeGui.closeQuest();
            this.treeGui.toggleSelected(this.quest);
        } else if (button.isRight()) {
            this.treeGui.movingQuest = false;
            if (this.treeGui.getViewedQuest() != this.quest) {
                this.treeGui.viewQuestPanel.hidePanel = true;
                this.treeGui.viewQuest(this.quest);
            } else {
                this.treeGui.closeQuest();
            }
        }
    }

    private void editDependency(Quest quest, QuestObject object, boolean add) {
        ArrayList<QuestObject> prevDeps = new ArrayList<QuestObject>(quest.dependencies);
        if (add != quest.hasDependency(object)) {
            if (add) {
                quest.dependencies.add(object);
            } else {
                for (int i = 0; i < quest.dependencies.size(); ++i) {
                    if (quest.dependencies.get(i) != object) continue;
                    quest.dependencies.remove(i);
                    break;
                }
            }
        }
        if (quest.verifyDependencies(false)) {
            new MessageEditObject(quest).sendToServer();
            this.treeGui.questPanel.refreshWidgets();
        } else {
            quest.dependencies.clear();
            quest.dependencies.addAll(prevDeps);
            GuiQuestTree.displayError((ITextComponent)new TextComponentTranslation("ftbquests.gui.looping_dependencies", new Object[0]));
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.quest.tasks.size() == 1 ? this.quest.tasks.get(0).getIngredient() : null;
    }

    public void addMouseOverText(List<String> list) {
        int r;
        int p;
        String title = this.getTitle();
        if (this.treeGui.file.self != null && (p = this.quest.getRelativeProgress(this.treeGui.file.self)) > 0 && p < 100) {
            title = title + " " + TextFormatting.DARK_GRAY + p + "%";
        }
        list.add(title);
        String description = this.quest.getDescription();
        if (!description.isEmpty()) {
            list.add(TextFormatting.GRAY + description);
        }
        if ((r = this.quest.getUnclaimedRewards(Minecraft.func_71410_x().field_71439_g.func_110124_au(), this.treeGui.file.self, true)) > 0) {
            list.add("");
            list.add(I18n.func_135052_a((String)"ftbquests.gui.collect_rewards", (Object[])new Object[]{TextFormatting.GOLD.toString() + r}));
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        boolean cantStart;
        Color4I outlineColor = Color4I.WHITE.withAlpha(150);
        Color4I qicon = Icon.EMPTY;
        boolean bl = cantStart = !this.quest.canStartTasks(this.treeGui.file.self);
        if (!cantStart) {
            int progress = this.quest.getRelativeProgress(this.treeGui.file.self);
            if (progress >= 100) {
                boolean hasRewards = false;
                for (Reward reward : this.quest.rewards) {
                    if (this.treeGui.file.self.isRewardClaimedSelf(reward)) continue;
                    hasRewards = true;
                    break;
                }
                qicon = hasRewards ? FTBQuestsTheme.ALERT : FTBQuestsTheme.COMPLETED;
                outlineColor = COL_COMPLETED.withAlpha(200);
            } else if (progress > 0) {
                outlineColor = COL_STARTED.withAlpha(200);
            }
        } else {
            outlineColor = Color4I.GRAY;
        }
        int z = this.treeGui.getZoom();
        int s = z * 3 / 2;
        int sx = x + (w - s) / 2;
        int sy = y + (h - s) / 2;
        this.quest.shape.shape.draw(sx, sy, s, s, Color4I.DARK_GRAY);
        this.quest.shape.background.draw(sx, sy, s, s, Color4I.WHITE.withAlpha(150));
        this.quest.shape.outline.draw(sx, sy, s, s, outlineColor);
        if (!this.icon.isEmpty()) {
            this.icon.draw(x + (w - z) / 2, y + (h - z) / 2, z, z);
        }
        if (this.quest == this.treeGui.viewQuestPanel.quest || this.treeGui.selectedQuests.contains(this.quest)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            Color4I col = Color4I.WHITE.withAlpha(190 + (int)(Math.sin((double)System.currentTimeMillis() * 0.003) * 50.0));
            this.quest.shape.outline.draw(sx, sy, s, s, col);
            this.quest.shape.background.draw(sx, sy, s, s, col);
            GlStateManager.func_179121_F();
        }
        if (cantStart) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            this.quest.shape.shape.draw(sx, sy, s, s, Color4I.BLACK.withAlpha(100));
            GlStateManager.func_179121_F();
        }
        if (this.isMouseOver()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            this.quest.shape.shape.draw(sx, sy, s, s, Color4I.WHITE.withAlpha(50));
            GlStateManager.func_179121_F();
        }
        if (!qicon.isEmpty()) {
            int s1 = z / 2;
            int os1 = s1 / 4;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            qicon.draw(x + w - s1 - os1, y + os1, s1, s1);
            GlStateManager.func_179121_F();
        }
    }
}

