/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.edit.MessageMoveChapter;
import com.feed_the_beast.ftbquests.quest.Chapter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ButtonExpandedChapter
extends SimpleTextButton {
    public final GuiQuestTree treeGui = (GuiQuestTree)this.getGui();
    public final Chapter chapter;
    public List<String> description;

    public ButtonExpandedChapter(Panel panel, Chapter c) {
        super(panel, c.getTitle(), c.getIcon());
        int p;
        this.chapter = c;
        if (this.treeGui.file.self != null && (p = c.getRelativeProgress(this.treeGui.file.self)) > 0 && p < 100) {
            this.setTitle(this.getTitle() + " " + TextFormatting.DARK_GREEN + p + "%");
        }
        this.description = new ArrayList<String>();
        for (String v : this.chapter.description) {
            this.description.add(TextFormatting.GRAY + FTBQuestsClient.addI18nAndColors(v));
        }
    }

    public void onClicked(MouseButton button) {
        if (this.treeGui.file.canEdit() || !this.chapter.quests.isEmpty()) {
            GuiHelper.playClickSound();
            if (this.treeGui.selectedChapter != this.chapter) {
                this.treeGui.open(this.chapter);
            }
        }
        if (this.treeGui.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), GuiIcons.UP, () -> new MessageMoveChapter(this.chapter.id, true).sendToServer()).setEnabled(() -> this.chapter.getIndex() > 0).setCloseMenu(false));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), GuiIcons.DOWN, () -> new MessageMoveChapter(this.chapter.id, false).sendToServer()).setEnabled(() -> this.chapter.getIndex() < this.treeGui.file.chapters.size() - 1).setCloseMenu(false));
            contextMenu.add(ContextMenuItem.SEPARATOR);
            GuiQuestTree.addObjectMenuItems(contextMenu, (IOpenableGui)this.getGui(), this.chapter);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    public void addMouseOverText(List<String> list) {
        list.addAll(this.description);
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawGui(x, y, w, h, WidgetType.NORMAL);
        if (this.isMouseOver()) {
            theme.drawButton(x, y, w, h, WidgetType.MOUSE_OVER);
        } else if (this.parent.widgets.size() > 1) {
            if (this.parent.widgets.get(0) == this) {
                theme.drawButton(x, y, w, h, WidgetType.NORMAL);
            } else {
                this.treeGui.borderColor.draw(x + w - 1, y, 1, h);
                if (this.parent.widgets.get(this.parent.widgets.size() - 1) == this) {
                    this.treeGui.borderColor.draw(x, y + h - 1, w - 1, h);
                }
            }
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        super.draw(theme, x, y, w, h);
        int w2 = 20;
        if (this.chapter.hasUnclaimedRewards(Minecraft.func_71410_x().field_71439_g.func_110124_au(), this.treeGui.file.self, true)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)450.0f);
            FTBQuestsTheme.ALERT.draw(x + w2 - 7, y + 3, 6, 6);
            GlStateManager.func_179121_F();
        } else if (this.chapter.isComplete(this.treeGui.file.self)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)450.0f);
            FTBQuestsTheme.COMPLETED.draw(x + w2 - 8, y + 2, 8, 8);
            GlStateManager.func_179121_F();
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.icon.getIngredient();
    }
}

