/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.editor;

import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconRenderer;
import com.feed_the_beast.ftblib.lib.net.MessageToServer;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.editor.QuestObjectBaseTreeItem;
import com.feed_the_beast.ftbquests.gui.editor.RunnableCallback;
import com.feed_the_beast.ftbquests.gui.editor.TabEditObject;
import com.feed_the_beast.ftbquests.net.edit.MessageDeleteObject;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;

public final class Editor {
    private static Stage mainWindow = null;
    private static boolean loaded = false;
    private static TabPane tabPane = null;
    private static Tab tabMain = null;

    public static void runLater(Runnable runnable) {
        Platform.runLater((Runnable)runnable);
    }

    public static void runLater(boolean runLater, Runnable runnable) {
        if (runLater) {
            Editor.runLater(runnable);
        } else {
            runnable.run();
        }
    }

    public static void open(boolean reload) {
        if (reload || !loaded) {
            ClientQuestFile.INSTANCE.clearCachedData();
            IconRenderer.clearCache();
        }
        if (!loaded) {
            loaded = true;
            new JFXPanel();
            Platform.setImplicitExit((boolean)false);
            Editor.runLater(() -> {
                mainWindow = new Stage();
                mainWindow.setTitle("FTB Quests Editor [Warning: Nearly nothing works properly yet!]");
                mainWindow.setMinWidth(500.0);
                mainWindow.setMinHeight(300.0);
                mainWindow.getIcons().add((Object)new Image("/assets/ftbquests/textures/logotransparent.png"));
                Editor.reloadMainScene();
                mainWindow.show();
            });
        } else if (mainWindow != null) {
            Editor.runLater(() -> {
                if (reload) {
                    ClientQuestFile.INSTANCE.clearCachedData();
                    Editor.reloadMainScene();
                }
                mainWindow.show();
            });
        }
    }

    public static Stage getMainWindow() {
        return mainWindow;
    }

    @Nullable
    public static ImageView iconView(@Nullable Image image) {
        if (image == null) {
            return null;
        }
        ImageView view = new ImageView(image);
        view.setFitWidth(16.0);
        view.setFitHeight(16.0);
        return view;
    }

    public static void loadIcon(Labeled node, @Nullable Icon icon) {
        IconRenderer.load((Icon)icon, (queued, image) -> Editor.runLater(queued, () -> {
            node.setGraphic((Node)Editor.iconView(image));
            if (queued) {
                node.requestLayout();
            }
        }));
    }

    public static void loadIcon(MenuItem node, @Nullable Icon icon) {
        IconRenderer.load((Icon)icon, (queued, image) -> Editor.runLater(queued, () -> node.setGraphic((Node)Editor.iconView(image))));
    }

    public static void loadIcon(Tab node, @Nullable Icon icon) {
        IconRenderer.load((Icon)icon, (queued, image) -> Editor.runLater(queued, () -> node.setGraphic((Node)Editor.iconView(image))));
    }

    private static void reloadMainScene() {
        tabMain = new Tab("FTB Quests");
        tabMain.setClosable(false);
        Editor.refreshMainTabContent();
        tabPane = new TabPane(new Tab[]{tabMain});
        mainWindow.setScene(new Scene((Parent)tabPane, 1000.0, 600.0));
    }

    public static void refreshMainTabContent() {
        VBox mainBox = new VBox();
        HBox buttonBox = new HBox();
        buttonBox.setSpacing(5.0);
        buttonBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        buttonBox.getChildren().add((Object)Editor.button(I18n.func_135052_a((String)"ftbquests.gui.wiki", (Object[])new Object[0]), GuiIcons.INFO, () -> System.out.println("Opening wiki...")));
        buttonBox.getChildren().add((Object)Editor.button(I18n.func_135052_a((String)"ftbquests.gui.save_as_file", (Object[])new Object[0]), GuiIcons.DOWN, () -> System.out.println("Saving as file...")));
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            buttonBox.getChildren().add((Object)Editor.button("", GuiIcons.REFRESH, () -> {
                IconRenderer.clearCache();
                Editor.reloadMainScene();
            }));
        }
        mainBox.getChildren().add((Object)buttonBox);
        QuestObjectBaseTreeItem rootNode = new QuestObjectBaseTreeItem(ClientQuestFile.INSTANCE);
        for (Chapter chapter : ClientQuestFile.INSTANCE.chapters) {
            if (chapter.hasGroup()) continue;
            QuestObjectBaseTreeItem chapterNode = new QuestObjectBaseTreeItem(chapter);
            rootNode.getChildren().add((Object)chapterNode);
            for (Chapter chapter1 : chapter.getChildren()) {
                QuestObjectBaseTreeItem subChapterNode = new QuestObjectBaseTreeItem(chapter1);
                chapterNode.getChildren().add((Object)subChapterNode);
                for (Quest quest : chapter1.quests) {
                    subChapterNode.getChildren().add((Object)new QuestObjectBaseTreeItem(quest));
                }
            }
            for (Quest quest : chapter.quests) {
                chapterNode.getChildren().add((Object)new QuestObjectBaseTreeItem(quest));
            }
            chapterNode.getChildren().sort(null);
        }
        rootNode.getChildren().sort(null);
        Editor.addSeperators(rootNode);
        TreeView objectTree = new TreeView();
        objectTree.setCellFactory(callback -> new TreeCell<QuestObjectBase>(){

            public void updateItem(QuestObjectBase object, boolean empty) {
                super.updateItem((Object)object, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setContextMenu(null);
                } else if (object == null || object.invalid) {
                    this.setText("---");
                    this.setGraphic(null);
                    this.setContextMenu(null);
                } else {
                    this.setText(object.getUnformattedTitle());
                    Editor.loadIcon((Labeled)this, object.getIcon());
                    ContextMenu menu = new ContextMenu();
                    menu.getItems().add((Object)Editor.menuItem(I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), GuiIcons.SETTINGS, () -> Editor.openTab(new TabEditObject(object))));
                    if (!(object instanceof QuestFile)) {
                        menu.getItems().add((Object)Editor.menuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, () -> Editor.scheduleMessage(new MessageDeleteObject())));
                    }
                    Menu changeProgressMenu = new Menu();
                    changeProgressMenu.setText(I18n.func_135052_a((String)"ftbquests.gui.change_progress", (Object[])new Object[0]));
                    Editor.loadIcon((MenuItem)changeProgressMenu, GuiIcons.TIME);
                    changeProgressMenu.getItems().add((Object)Editor.menuItem(I18n.func_135052_a((String)"ftbquests.gui.change_progress.reset", (Object[])new Object[0]), GuiIcons.REFRESH, () -> {}));
                    changeProgressMenu.getItems().add((Object)Editor.menuItem(I18n.func_135052_a((String)"ftbquests.gui.change_progress.reset_deps", (Object[])new Object[0]), GuiIcons.REFRESH, () -> {}));
                    changeProgressMenu.getItems().add((Object)Editor.menuItem(I18n.func_135052_a((String)"ftbquests.gui.change_progress.complete", (Object[])new Object[0]), GuiIcons.ACCEPT, () -> {}));
                    changeProgressMenu.getItems().add((Object)Editor.menuItem(I18n.func_135052_a((String)"ftbquests.gui.change_progress.complete_deps", (Object[])new Object[0]), GuiIcons.ACCEPT, () -> {}));
                    menu.getItems().add((Object)changeProgressMenu);
                    this.setContextMenu(menu);
                }
            }
        });
        objectTree.setRoot((TreeItem)rootNode);
        objectTree.setShowRoot(true);
        rootNode.setExpanded(true);
        tabMain.setContent((Node)objectTree);
    }

    private static void addSeperators(QuestObjectBaseTreeItem item) {
        QuestObjectType type = null;
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        for (TreeItem item1 : item.getChildren()) {
            if (item1 instanceof QuestObjectBaseTreeItem) {
                QuestObjectType t = ((QuestObjectBase)item1.getValue()).getObjectType();
                if (type == null) {
                    type = t;
                } else if (type != t) {
                    type = t;
                    list.add(new TreeItem());
                }
                Editor.addSeperators((QuestObjectBaseTreeItem)item1);
            }
            list.add(item1);
        }
        item.getChildren().clear();
        item.getChildren().addAll(list);
    }

    public static void openTab(Tab tab) {
        tab.setClosable(true);
        tabPane.getTabs().add((Object)tab);
        tabPane.getSelectionModel().select((Object)tab);
    }

    private static Button button(String title, @Nullable Icon icon, Runnable click) {
        Button button = new Button();
        button.setText(title);
        Editor.loadIcon((Labeled)button, icon);
        button.setOnAction((EventHandler)new RunnableCallback(click));
        return button;
    }

    private static MenuItem menuItem(String title, @Nullable Icon icon, Runnable click) {
        MenuItem item = new MenuItem();
        item.setText(title);
        Editor.loadIcon(item, icon);
        item.setOnAction((EventHandler)new RunnableCallback(click));
        return item;
    }

    public static String toString(ItemStack stack) {
        return StringUtils.unformatted((String)stack.func_82833_r());
    }

    public static void schedule(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }

    public static void scheduleMessage(MessageToServer message) {
        Editor.schedule(() -> ((MessageToServer)message).sendToServer());
    }

    public static void scheduleObjectEdit(QuestObjectBase object) {
        Editor.scheduleMessage(new MessageEditObject(object));
    }
}

