/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.editor;

import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigEnum;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftbquests.gui.editor.ConfigCheckbox;
import com.feed_the_beast.ftbquests.gui.editor.ConfigComboBox;
import com.feed_the_beast.ftbquests.gui.editor.ConfigEditedCallback;
import com.feed_the_beast.ftbquests.gui.editor.Editor;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;

public class ConfigPane
extends GridPane
implements ConfigEditedCallback {
    public final QuestObjectBase object;
    public ConfigGroup original;
    public ConfigGroup group;
    public Button buttonReset;
    public Button buttonSave;

    public ConfigPane(QuestObjectBase o) {
        this.object = o;
        this.setMinSize(400.0, 200.0);
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.setVgap(5.0);
        this.setHgap(5.0);
        this.setAlignment(Pos.CENTER);
        this.buttonReset = new Button();
        this.buttonReset.setText("Reset");
        this.buttonReset.setDisable(true);
        this.buttonReset.setOnAction(event -> {
            this.group.deserializeNBT(this.original.serializeNBT());
            this.refreshConfig();
        });
        this.buttonSave = new Button();
        this.buttonSave.setText("Save");
        this.buttonSave.setDefaultButton(true);
        this.buttonSave.setDisable(true);
        this.buttonSave.setOnAction(event -> {
            Editor.scheduleObjectEdit(this.object);
            this.buttonSave.setDisable(true);
        });
        this.original = ConfigGroup.newGroup((String)"ftbquests");
        this.object.getConfig(this.object.createSubGroup(this.original));
        this.group = this.original.copy();
        this.refreshConfig();
    }

    public void refreshConfig() {
        this.getChildren().clear();
        int row = 0;
        ConfigGroup prevGroup = null;
        for (ConfigValueInstance instance : this.group.getValueTree()) {
            EventHandler valueNode;
            ConfigGroup g = instance.getGroup();
            if (prevGroup == null) {
                prevGroup = g;
            } else if (prevGroup != g) {
                prevGroup = g;
                this.addRow(row, new Node[]{new Separator(), new Separator()});
                ++row;
            }
            ConfigValue value = instance.getValue();
            if (value instanceof ConfigBoolean) {
                valueNode = new ConfigCheckbox((ConfigBoolean)value, this);
            } else if (value instanceof ConfigEnum) {
                valueNode = new ConfigComboBox((ConfigEnum)value, this);
            } else {
                TextField field = new TextField(value.getString());
                field.setOnAction(event -> {
                    value.setValueFromString((ICommandSender)Minecraft.func_71410_x().field_71439_g, field.getText(), false);
                    this.configEdited(value);
                });
                field.setOnKeyTyped(event -> {
                    value.setValueFromString((ICommandSender)Minecraft.func_71410_x().field_71439_g, field.getText(), false);
                    this.configEdited(value);
                });
                valueNode = field;
            }
            this.addRow(row, new Node[]{new Text(instance.getDisplayName().func_150260_c()), valueNode});
            ++row;
        }
        this.addRow(row, new Node[]{new Separator(), new Separator()});
        this.addRow(++row, new Node[]{this.buttonReset, this.buttonSave});
    }

    @Override
    public void configEdited(ConfigValue value) {
        this.buttonReset.setDisable(false);
        this.buttonSave.setDisable(false);
    }
}

