/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftbquests.client.ClientQuestData;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenCore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.TextFormatting;

public class RenderProgressScreen
extends TileEntitySpecialRenderer<TileProgressScreenCore> {
    public static final Color4I COLOR_NOT_STARTED = Color4I.rgb((int)0xFF4747);
    public static final Color4I COLOR_IN_PROGRESS = Color4I.rgb((int)16768834);
    public static final Color4I COLOR_COMPLETED = Color4I.rgb((int)6869825);

    public void render(TileProgressScreenCore screen, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!ClientQuestFile.exists()) {
            return;
        }
        Chapter chapter = ClientQuestFile.INSTANCE.getChapter(screen.chapter);
        if (chapter == null) {
            return;
        }
        ClientQuestData team = ClientQuestFile.INSTANCE.getData(screen.team);
        if (team == null) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(screen.getFacing().func_185119_l() + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.func_190053_a(true);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179141_d();
        FontRenderer font = this.func_147498_b();
        boolean flag = font.func_82883_a();
        font.func_78264_a(true);
        int size = Math.min(screen.width * 2, screen.height);
        GlStateManager.func_179109_b((float)((float)(-size) / 2.0f), (float)(-size), (float)-0.001f);
        GlStateManager.func_179152_a((float)((float)size + 1.0f), (float)((float)size + 1.0f), (float)1.0f);
        if (!screen.fullscreen) {
            this.drawString(font, chapter.getYellowDisplayName() + TextFormatting.RESET + " | " + ((QuestData)team).getDisplayName().func_150254_d(), 0.02, 0.12);
            this.drawString(font, chapter.getRelativeProgress(team) + "%", 0.86, 0.12);
        }
        if (!chapter.quests.isEmpty()) {
            int minX = 26;
            int minY = 26;
            int maxX = -26;
            int maxY = -26;
            for (Quest quest : chapter.quests) {
                minX = Math.min(minX, quest.x);
                minY = Math.min(minY, quest.y);
                maxX = Math.max(maxX, quest.x);
                maxY = Math.max(maxY, quest.y);
            }
            int sizeX = maxX - minX + 1;
            int sizeY = maxY - minY + 1;
            if (!screen.fullscreen) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.15f, (float)0.15f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)1.0f);
            }
            GlStateManager.func_179090_x();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int a = 255;
            for (Quest quest : chapter.quests) {
                int b;
                int g;
                int r;
                int p = quest.getRelativeProgress(team);
                if (p == 0) {
                    r = COLOR_NOT_STARTED.redi();
                    g = COLOR_NOT_STARTED.greeni();
                    b = COLOR_NOT_STARTED.bluei();
                } else if (p == 100) {
                    r = COLOR_COMPLETED.redi();
                    g = COLOR_COMPLETED.greeni();
                    b = COLOR_COMPLETED.bluei();
                } else {
                    r = COLOR_IN_PROGRESS.redi();
                    g = COLOR_IN_PROGRESS.greeni();
                    b = COLOR_IN_PROGRESS.bluei();
                }
                double rx = (double)(quest.x - minX) / (double)sizeX + 0.0025;
                double ry = (double)(quest.y - minY) / (double)sizeY + 0.0025;
                double rw = 1.0 / (double)sizeX - 0.005;
                double rh = 1.0 / (double)sizeY - 0.005;
                buffer.func_181662_b(rx, ry, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(rx, ry + rh, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(rx + rw, ry + rh, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(rx + rw, ry, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            double d = 3.0 * ((double)size + 1.0);
            if (!screen.hideIcons && Minecraft.func_71410_x().field_71439_g.func_70092_e((double)screen.func_174877_v().func_177958_n() + 0.5, (double)screen.func_174877_v().func_177956_o() + 0.5 + (double)screen.height / 2.0, (double)screen.func_174877_v().func_177952_p() + 0.5) <= d * d) {
                for (Quest quest : chapter.quests) {
                    double rx = ((double)(quest.x - minX) + 0.5) / (double)sizeX;
                    double ry = ((double)(quest.y - minY) + 0.5) / (double)sizeY;
                    int s = Math.max(sizeX, sizeY);
                    double rw = 0.75 / (double)s;
                    double rh = 0.75 / (double)s;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)rx, (double)ry, (double)-0.009f);
                    GlStateManager.func_179139_a((double)rw, (double)rh, (double)1.0);
                    quest.getIcon().draw3D(Icon.EMPTY);
                    GlStateManager.func_179121_F();
                }
            }
            if (!screen.fullscreen) {
                GlStateManager.func_179121_F();
            }
        }
        font.func_78264_a(flag);
        this.func_190053_a(false);
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void drawString(FontRenderer font, String string, double y, double size) {
        if (string.isEmpty()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.5, (double)y, (double)0.0);
        int len = font.func_78256_a(string);
        double scale = size / 9.0;
        double w = (double)len * scale;
        if (w > 1.0) {
            scale /= w;
            w = 1.0;
        }
        if (w > 0.9) {
            scale *= 0.9;
        }
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
        font.func_78276_b(string, -len / 2, 0, -2565928);
        GlStateManager.func_179121_F();
    }
}

