/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.net.MessageMyTeamGui;
import com.feed_the_beast.ftbquests.client.ClientQuestData;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageSyncQuests;
import com.feed_the_beast.ftbquests.net.edit.MessageDeleteObject;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.task.Task;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ClientQuestFile
extends QuestFile {
    public static ClientQuestFile INSTANCE;
    private final Short2ObjectOpenHashMap<ClientQuestData> teamData = new Short2ObjectOpenHashMap();
    public ClientQuestData self;
    public GuiQuestTree questTreeGui;
    public GuiBase questGui;
    public boolean editingMode;
    public final Object2ShortOpenHashMap<UUID> playerTeams = new Object2ShortOpenHashMap();

    public static boolean exists() {
        return INSTANCE != null && !ClientQuestFile.INSTANCE.invalid;
    }

    public static boolean existsWithTeam() {
        return ClientQuestFile.exists() && ClientQuestFile.INSTANCE.self != null;
    }

    public ClientQuestFile() {
        this.playerTeams.defaultReturnValue((short)0);
    }

    public void load(MessageSyncQuests message) {
        if (INSTANCE != null) {
            INSTANCE.deleteChildren();
            INSTANCE.deleteSelf();
        }
        INSTANCE = this;
        for (MessageSyncQuests.TeamInst team : message.teamData) {
            int i;
            ClientQuestData data = new ClientQuestData(team.uid, team.id, team.name);
            for (Chapter chapter : this.chapters) {
                for (Quest quest : chapter.quests) {
                    for (Task task : quest.tasks) {
                        data.createTaskData(task);
                    }
                }
            }
            for (i = 0; i < team.taskKeys.length; ++i) {
                Task task = this.getTask(team.taskKeys[i]);
                if (task == null) continue;
                data.getTaskData(task).readProgress(team.taskValues[i]);
            }
            for (i = 0; i < team.playerRewardUUIDs.length; ++i) {
                data.claimedPlayerRewards.put(team.playerRewardUUIDs[i], this.fromArray(team.playerRewardIDs[i]));
            }
            data.claimedTeamRewards.addAll((IntCollection)this.fromArray(team.teamRewards));
            this.teamData.put(data.getTeamUID(), (Object)data);
        }
        this.self = message.team == 0 ? null : (ClientQuestData)this.teamData.get(message.team);
        this.editingMode = message.editingMode;
        this.playerTeams.clear();
        for (int i = 0; i < message.playerIDs.length; ++i) {
            this.playerTeams.put((Object)message.playerIDs[i], message.playerTeams[i]);
        }
        this.refreshGui();
        FTBQuestsJEIHelper.refresh(this);
    }

    private IntOpenHashSet fromArray(int[] array) {
        IntOpenHashSet set = new IntOpenHashSet(array.length);
        for (int i : array) {
            set.add(i);
        }
        return set;
    }

    @Override
    public boolean canEdit() {
        return this.editingMode;
    }

    public void refreshGui() {
        this.clearCachedData();
        boolean hasPrev = false;
        boolean guiOpen = false;
        int zoom = 0;
        int scrollX = 0;
        int scrollY = 0;
        int selectedChapter = 0;
        int[] selectedQuests = new int[]{};
        if (this.questTreeGui != null) {
            hasPrev = true;
            zoom = this.questTreeGui.zoom;
            scrollX = this.questTreeGui.questPanel.getScrollX();
            scrollY = this.questTreeGui.questPanel.getScrollY();
            selectedChapter = this.questTreeGui.selectedChapter == null ? 0 : this.questTreeGui.selectedChapter.id;
            selectedQuests = new int[this.questTreeGui.selectedQuests.size()];
            int i = 0;
            for (Quest q : this.questTreeGui.selectedQuests) {
                selectedQuests[i] = q.id;
                ++i;
            }
            if (ClientUtils.getCurrentGuiAs(GuiQuestTree.class) != null) {
                guiOpen = true;
            }
        }
        this.questTreeGui = new GuiQuestTree(this);
        this.questGui = this.questTreeGui;
        if (hasPrev) {
            this.questTreeGui.zoom = zoom;
            this.questTreeGui.selectChapter(this.getChapter(selectedChapter));
            for (int i : selectedQuests) {
                this.questTreeGui.selectedQuests.add(this.getQuest(i));
            }
            if (guiOpen) {
                this.questTreeGui.openGui();
            }
        }
        this.questTreeGui.refreshWidgets();
        if (hasPrev) {
            this.questTreeGui.questPanel.setScrollX(scrollX);
            this.questTreeGui.questPanel.setScrollY(scrollY);
        }
    }

    public void openQuestGui(EntityPlayer player) {
        if (this.disableGui && !this.editingMode) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ftbquests.book.disabled", new Object[0]), true);
        } else if (ClientQuestFile.existsWithTeam()) {
            this.questGui.openGui();
        } else {
            new MessageMyTeamGui().sendToServer();
        }
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    @Nullable
    public ClientQuestData getData(short team) {
        return team == 0 ? null : (ClientQuestData)this.teamData.get(team);
    }

    @Override
    @Nullable
    public QuestData getData(Entity player) {
        return this.getData(this.playerTeams.getShort((Object)player.func_110124_au()));
    }

    public ClientQuestData removeData(short team) {
        return (ClientQuestData)this.teamData.remove(team);
    }

    public void addData(ClientQuestData data) {
        this.teamData.put(data.getTeamUID(), (Object)data);
    }

    @Override
    @Nullable
    public ClientQuestData getData(String team) {
        if (team.isEmpty()) {
            return null;
        }
        for (ClientQuestData data : this.teamData.values()) {
            if (!team.equals(data.getTeamID())) continue;
            return data;
        }
        return null;
    }

    public Collection<ClientQuestData> getAllData() {
        return this.teamData.values();
    }

    @Override
    public void deleteObject(int id) {
        new MessageDeleteObject(id).sendToServer();
    }
}

