/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.manatweaks.common.zen.expansions;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityEquipmentSlot;
import nihiltres.manatweaks.common.zen.classes.DamageHelper;
import nihiltres.manatweaks.common.zen.classes.ManaHandler;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenExpansion(value="crafttweaker.entity.IEntity")
@ZenRegister
public class ExpansionIEntity {
    @ZenMethod
    public static boolean manaRepairSlot(IEntity entity, IEntityEquipmentSlot islot, @Optional(value="140") int manaAmount, @Optional(value="1") int repairAmount, @Optional boolean discounted) {
        return ManaHandler.manaRepairEntitySlot(entity, islot, manaAmount, repairAmount, discounted);
    }

    @ZenMethod
    public static boolean manaRepairSlot(IEntity entity, int slotNum, @Optional(value="120") int manaAmount, @Optional(value="1") int repairAmount, @Optional boolean discounted) {
        return ManaHandler.manaRepairEntitySlot(entity, slotNum, manaAmount, repairAmount, discounted);
    }

    @ZenMethod
    public static boolean canRepairSlot(IEntity entity, IEntityEquipmentSlot islot, @Optional(value="1") int repairAmount) {
        return DamageHelper.isSafeDamageModification(DamageHelper.getStackFromSlot(entity, islot), -repairAmount);
    }

    @ZenMethod
    public static boolean canRepairSlot(IEntity entity, int slotNum, @Optional(value="1") int repairAmount) {
        return DamageHelper.isSafeDamageModification(DamageHelper.getStackFromSlot(entity, slotNum), -repairAmount);
    }

    @ZenMethod
    public static boolean repairSlot(IEntity entity, IEntityEquipmentSlot islot, @Optional(value="1") int repairAmount) {
        return DamageHelper.repair(DamageHelper.getStackFromSlot(entity, islot), repairAmount);
    }

    @ZenMethod
    public static boolean repairSlot(IEntity entity, int slotNum, @Optional(value="1") int repairAmount) {
        return DamageHelper.repair(DamageHelper.getStackFromSlot(entity, slotNum), repairAmount);
    }

    @ZenMethod
    public static boolean canDamageSlot(IEntity entity, IEntityEquipmentSlot islot, @Optional(value="1") int damageAmount) {
        return DamageHelper.isSafeDamageModification(DamageHelper.getStackFromSlot(entity, islot), damageAmount);
    }

    @ZenMethod
    public static boolean canDamageSlot(IEntity entity, int slotNum, @Optional(value="1") int damageAmount) {
        return DamageHelper.isSafeDamageModification(DamageHelper.getStackFromSlot(entity, slotNum), damageAmount);
    }

    @ZenMethod
    public static boolean damageSlot(IEntity entity, IEntityEquipmentSlot islot, @Optional(value="1") int damageAmount) {
        return DamageHelper.damage(DamageHelper.getStackFromSlot(entity, islot), damageAmount);
    }

    @ZenMethod
    public static boolean damageSlot(IEntity entity, int slotNum, @Optional(value="1") int damageAmount) {
        return DamageHelper.damage(DamageHelper.getStackFromSlot(entity, slotNum), damageAmount);
    }
}

