/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.manatweaks.common.zen.classes;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.potions.IPotionEffect;
import crafttweaker.api.world.IBlockPos;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.common.entity.EntityPixie;

@ZenClass(value="mods.manatweaks.PixieHandler")
@ZenRegister
public class PixieHandler {
    private static PotionEffect[] defaultPotionEffects = new PotionEffect[]{new PotionEffect(MobEffects.field_76440_q, 40, 0), new PotionEffect(MobEffects.field_76421_d, 40, 0), new PotionEffect(MobEffects.field_76437_t, 40, 0), new PotionEffect(MobEffects.field_82731_v, 40, 0)};

    private static boolean checkNull(Object obj, String name) {
        if (obj != null) {
            return true;
        }
        throw new IllegalArgumentException(String.format("%s argument cannot be null", name));
    }

    @ZenMethod
    public static void spawnPixie(double x, double y, double z, IEntity targetIn, IEntity playerIn, float damage, IPotionEffect ... effectArr) {
        PixieHandler.checkNull(targetIn, "Target");
        PixieHandler.checkNull(playerIn, "Player");
        PixieHandler.checkNull(effectArr, "Effects");
        if (!(playerIn.getInternal() instanceof EntityPlayer) || !(targetIn.getInternal() instanceof EntityLivingBase)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)playerIn.getInternal();
        World world = player.field_70170_p;
        EntityLivingBase target = (EntityLivingBase)targetIn.getInternal();
        EntityPixie pixie = new EntityPixie(world);
        pixie.func_70107_b(x, y, z);
        int rand = world.field_73012_v.nextInt(effectArr.length);
        pixie.setApplyPotionEffect((PotionEffect)effectArr[rand].getInternal());
        pixie.setProps(target, (EntityLivingBase)player, 0, damage);
        world.func_72838_d((Entity)pixie);
    }

    @ZenMethod
    public static void spawnPixie(IBlockPos pos, IEntity targetIn, IEntity playerIn, float damage, IPotionEffect ... effectArr) {
        PixieHandler.spawnPixie(pos.getX(), pos.getY(), pos.getZ(), targetIn, playerIn, damage, effectArr);
    }

    @ZenMethod
    public static void spawnPixie(double x, double y, double z, IEntity targetIn, IEntity playerIn, @Optional(value="4.0f") float damage) {
        PixieHandler.checkNull(targetIn, "Target");
        PixieHandler.checkNull(playerIn, "Player");
        if (!(playerIn.getInternal() instanceof EntityPlayer) || !(targetIn.getInternal() instanceof EntityLivingBase)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)playerIn.getInternal();
        World world = player.field_70170_p;
        EntityLivingBase target = (EntityLivingBase)targetIn.getInternal();
        EntityPixie pixie = new EntityPixie(world);
        pixie.func_70107_b(x, y, z);
        int rand = world.field_73012_v.nextInt(defaultPotionEffects.length);
        pixie.setApplyPotionEffect(defaultPotionEffects[rand]);
        pixie.setProps(target, (EntityLivingBase)player, 0, damage);
        world.func_72838_d((Entity)pixie);
    }

    @ZenMethod
    public static void spawnPixie(IBlockPos pos, IEntity targetIn, IEntity playerIn, @Optional(value="4.0f") float damage) {
        PixieHandler.spawnPixie(pos.getX(), pos.getY(), pos.getZ(), targetIn, playerIn, damage);
    }

    @ZenMethod
    public static void spawnPixie(IEntity targetIn, IEntity playerIn) {
        PixieHandler.spawnPixie(playerIn.getPosX(), playerIn.getPosY() + 2.0, playerIn.getPosZ(), targetIn, playerIn, 4.0f);
    }
}

