/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.manatweaks.common.zen.classes;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.item.MCItemDefinition;
import crafttweaker.mc1120.player.MCPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nihiltres.manatweaks.common.zen.classes.ManaDiscountFunction;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.mana.ManaDiscountEvent;

@ZenClass(value="mods.manatweaks.ManaDiscounter")
@ZenRegister
@Mod.EventBusSubscriber
public class ManaDiscounter {
    private static Map<Item, ManaDiscountFunction> discountMap = new HashMap<Item, ManaDiscountFunction>(12);

    @SubscribeEvent
    public static void handleEvent(ManaDiscountEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        NonNullList armourInventory = player.field_71071_by.field_70460_b;
        for (int i = 0; i < armourInventory.size(); ++i) {
            Item armourItem = ((ItemStack)armourInventory.get(i)).func_77973_b();
            if (!discountMap.containsKey(armourItem)) continue;
            event.setDiscount(event.getDiscount() + discountMap.get(armourItem).handle((IPlayer)new MCPlayer(player), InputHelper.toIItemStack((ItemStack)((ItemStack)armourInventory.get(i))), InputHelper.toIItemStack((ItemStack)event.getTool())));
        }
    }

    private static final Item getItem(IItemStack stack) {
        return (Item)stack.getDefinition().getInternal();
    }

    @ZenMethod
    public static boolean addDiscount(IItemStack stack, ManaDiscountFunction func) {
        if (func == null) {
            return false;
        }
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Item item = ManaDiscounter.getItem(stack);
        if (item == null || item == Items.field_190931_a) {
            return false;
        }
        discountMap.put(item, func);
        return true;
    }

    @ZenMethod
    public static boolean addDiscount(IItemDefinition itemDef, ManaDiscountFunction func) {
        Item item = (Item)itemDef.getInternal();
        if (item == null || item == Items.field_190931_a) {
            return false;
        }
        discountMap.put(item, func);
        return true;
    }

    @ZenMethod
    public static boolean removeDiscount(IItemStack stack) {
        return discountMap.remove(ManaDiscounter.getItem(stack)) == null;
    }

    @ZenMethod
    public static ManaDiscountFunction getDiscount(IItemStack stack) {
        return discountMap.get(ManaDiscounter.getItem(stack));
    }

    @ZenMethod
    public static List<IItemDefinition> getDiscountedItems() {
        ArrayList<IItemDefinition> list = new ArrayList<IItemDefinition>(discountMap.keySet().size());
        for (Item i : discountMap.keySet()) {
            list.add((IItemDefinition)new MCItemDefinition(i.getRegistryName().toString(), i));
        }
        return list;
    }
}

