/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.manatweaks.common.zen.classes;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityEquipmentSlot;
import crafttweaker.api.item.IItemStack;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.manatweaks.DamageHelper")
@ZenRegister
public class DamageHelper {
    public static boolean isSafeDamageModification(ItemStack stack, int modAmount) {
        if (modAmount == 0) {
            return false;
        }
        return stack != null && !stack.func_190926_b() && stack.func_77984_f() && (modAmount < 0 && stack.func_77952_i() >= -modAmount || modAmount > 0 && stack.func_77952_i() + modAmount <= stack.func_77958_k());
    }

    @ZenMethod
    public static boolean isSafeDamageModification(IItemStack stack, int modAmount) {
        return DamageHelper.isSafeDamageModification((ItemStack)stack.getInternal(), modAmount);
    }

    public static boolean damage(ItemStack stack, int damageAmount) {
        if (DamageHelper.isSafeDamageModification(stack, damageAmount)) {
            stack.func_77964_b(stack.func_77952_i() + damageAmount);
            return true;
        }
        return false;
    }

    @ZenMethod
    public static boolean damage(IItemStack stack, int damageAmount) {
        return DamageHelper.damage((ItemStack)stack.getInternal(), damageAmount);
    }

    public static boolean repair(ItemStack stack, int repairAmount) {
        if (DamageHelper.isSafeDamageModification(stack, -repairAmount)) {
            stack.func_77964_b(stack.func_77952_i() - repairAmount);
            return true;
        }
        return false;
    }

    @ZenMethod
    public static boolean repair(IItemStack stack, int repairAmount) {
        return DamageHelper.repair((ItemStack)stack.getInternal(), repairAmount);
    }

    @ZenMethod
    public static ItemStack getStackFromSlot(IEntity entity, IEntityEquipmentSlot islot) {
        Object internalEntity = entity.getInternal();
        if (internalEntity instanceof EntityLivingBase) {
            EntityEquipmentSlot slot = (EntityEquipmentSlot)islot.getInternal();
            return ((EntityLivingBase)internalEntity).func_184582_a(slot);
        }
        return null;
    }

    @ZenMethod
    public static ItemStack getStackFromSlot(IEntity entity, int slotNum) {
        Object internalEntity = entity.getInternal();
        if (internalEntity instanceof EntityPlayer) {
            return ((EntityPlayer)internalEntity).field_71071_by.func_70301_a(slotNum);
        }
        return null;
    }
}

