/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.gui.provided.book.search;

import com.teamwizardry.librarianlib.features.gui.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.IBookElement;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.entry.Entry;
import com.teamwizardry.librarianlib.features.gui.provided.book.search.ISearchAlgorithm;
import com.teamwizardry.librarianlib.features.gui.provided.book.search.TFIDFSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\n\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/TFIDFSearch;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/ISearchAlgorithm;", "book", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/IBookGui;", "(Lcom/teamwizardry/librarianlib/features/gui/provided/book/IBookGui;)V", "search", "", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/ISearchAlgorithm$Result;", "input", "", "FrequencySearchResult", "MatchCountSearchResult", "librarianlib-1.12.2"})
public final class TFIDFSearch
implements ISearchAlgorithm {
    private final IBookGui book;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<ISearchAlgorithm.Result> search(@NotNull String input) {
        String pattern2;
        Object object;
        Object object2;
        Object it22;
        List list2;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        String string = StringsKt.replace$default((String)input, (String)"'", (String)"", (boolean)false, (int)4, null);
        Locale locale = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
        Object object3 = locale;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase((Locale)object3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String query = string3;
        object3 = query;
        String string4 = " ";
        string4 = new Regex(string4);
        int n = 0;
        object3 = string4.split((CharSequence)object3, n);
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                CharSequence charSequence = it;
                if (charSequence.length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        $receiver$iv = list2;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] keywords = stringArray;
        ArrayList<FrequencySearchResult> unfilteredTfidfResults = new ArrayList<FrequencySearchResult>();
        ArrayList<MatchCountSearchResult> matchCountSearchResults = new ArrayList<MatchCountSearchResult>();
        Map<Entry, String> contentCache = this.book.getCachedSearchContent();
        int nbOfDocuments = contentCache.size();
        for (Entry cachedEntry : contentCache.keySet()) {
            Map.Entry mostRepeatedWord;
            Map map;
            Function1 $receiver$iv2;
            Iterator $receiver$iv$iv;
            Map $receiver$iv3;
            List list3;
            CharSequence charSequence;
            Object iterator$iv;
            void $receiver$iv4;
            EntityPlayerSP entityPlayerSP = player;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerSP, (String)"player");
            if (!cachedEntry.isUnlocked((EntityPlayer)entityPlayerSP)) continue;
            String string5 = contentCache.getOrDefault(cachedEntry, "");
            Locale locale2 = Locale.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.ROOT");
            Object object4 = locale2;
            String string6 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase((Locale)object4);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
            String cachedDocument = StringsKt.replace$default((String)string7, (String)"'", (String)"", (boolean)false, (int)4, null);
            object4 = cachedDocument;
            String string8 = "\\s+";
            string8 = new Regex(string8);
            int n2 = 0;
            object4 = string8.split((CharSequence)object4, n2);
            if (!$receiver$iv4.isEmpty()) {
                iterator$iv = $receiver$iv4.listIterator($receiver$iv4.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    charSequence = it;
                    if (charSequence.length() == 0) continue;
                    list3 = CollectionsKt.take((Iterable)((Iterable)$receiver$iv4), (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            List words = list3;
            iterator$iv = CollectionsKt.toSet((Iterable)words);
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$receiver$iv3), (int)10)), (int)16);
            charSequence = $receiver$iv3;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            Iterator $i$f$dropLastWhile = $receiver$iv$iv.iterator();
            while ($i$f$dropLastWhile.hasNext()) {
                int n3;
                Object element$iv$iv = $i$f$dropLastWhile.next();
                Map map2 = destination$iv$iv2;
                String it = (String)element$iv$iv;
                Iterable iterable = words;
                String string9 = it;
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    n3 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $receiver$iv2) {
                        String word = (String)element$iv;
                        if (!Intrinsics.areEqual((Object)word, (Object)it)) continue;
                        ++count$iv;
                    }
                    n3 = count$iv;
                }
                int n4 = n3;
                Pair pair = TuplesKt.to((Object)string9, (Object)n4);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            $receiver$iv3 = destination$iv$iv2;
            Iterable iterable = $receiver$iv3.entrySet();
            $receiver$iv$iv = iterable.iterator();
            if (!$receiver$iv$iv.hasNext()) {
                map = null;
            } else {
                destination$iv$iv2 = $receiver$iv$iv.next();
                it22 = (Map.Entry)((Object)destination$iv$iv2);
                int it22 = ((Number)it22.getValue()).intValue();
                while ($receiver$iv$iv.hasNext()) {
                    Object $i$a$2$maxBy = $receiver$iv$iv.next();
                    Map.Entry it32 = (Map.Entry)$i$a$2$maxBy;
                    int it32 = ((Number)it32.getValue()).intValue();
                    if (it22 >= it32) continue;
                    destination$iv$iv2 = $i$a$2$maxBy;
                    it22 = it32;
                }
                map = destination$iv$iv2;
            }
            if ((mostRepeatedWord = (Map.Entry)((Object)map)) == null) continue;
            double documentTfidf = 0.0;
            int it22 = keywords.length;
            for (int destination$iv$iv2 = 0; destination$iv$iv2 < it22; ++destination$iv$iv2) {
                int n5;
                Entry it;
                Iterable $receiver$iv$iv2;
                Iterable $receiver$iv5;
                String keyword = keywords[destination$iv$iv2];
                CharSequence it32 = keyword;
                Object $i$a$2$maxBy = "[\\\\.+*?^$\\[\\](){}/'#:!=|]";
                object2 = new StringBuilder().append("\\b");
                $i$a$2$maxBy = object = new Regex((String)$i$a$2$maxBy);
                $receiver$iv2 = search.pattern.1.INSTANCE;
                object = $i$a$2$maxBy.replace(it32, $receiver$iv2);
                pattern2 = ((StringBuilder)object2).append((String)object).toString();
                $i$a$2$maxBy = pattern2;
                int keywordOccurance = SequencesKt.count((Sequence)Regex.findAll$default((Regex)new Regex((String)$i$a$2$maxBy), (CharSequence)cachedDocument, (int)0, (int)2, null)) - 1;
                double termFrequency = 0.5 + 0.5 * (double)keywordOccurance / ((Number)mostRepeatedWord.getValue()).doubleValue();
                Iterable count$iv = contentCache.keySet();
                void var25_58 = $receiver$iv5;
                Object destination$iv$iv3 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    it = (Entry)element$iv$iv;
                    if (!it.isUnlocked((EntityPlayer)player)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                $receiver$iv5 = (List)destination$iv$iv3;
                $receiver$iv$iv2 = $receiver$iv5;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv5, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    Locale locale3;
                    it = (Entry)item$iv$iv;
                    object2 = destination$iv$iv3;
                    String $i$a$1$filter = contentCache.getOrDefault(it, "");
                    Intrinsics.checkExpressionValueIsNotNull((Object)Locale.ROOT, (String)"Locale.ROOT");
                    String string10 = $i$a$1$filter;
                    if (string10 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string10.toLowerCase(locale3), (String)"(this as java.lang.String).toLowerCase(locale)");
                    object2.add(object);
                }
                $receiver$iv5 = (List)destination$iv$iv3;
                if ($receiver$iv5 instanceof Collection && ((Collection)$receiver$iv5).isEmpty()) {
                    n5 = 0;
                } else {
                    int count$iv2 = 0;
                    for (Object element$iv : $receiver$iv5) {
                        String it3 = (String)element$iv;
                        if (!StringsKt.contains$default((CharSequence)it3, (CharSequence)keyword, (boolean)false, (int)2, null)) continue;
                        ++count$iv2;
                    }
                    n5 = count$iv2;
                }
                int keywordDocumentOccurance = n5;
                keywordDocumentOccurance = keywordDocumentOccurance == 0 ? keywordDocumentOccurance + 1 : keywordDocumentOccurance;
                double inverseDocumentFrequency = Math.log(nbOfDocuments / keywordDocumentOccurance);
                double keywordTfidf = termFrequency * inverseDocumentFrequency;
                documentTfidf += keywordTfidf;
            }
            unfilteredTfidfResults.add(new FrequencySearchResult(cachedEntry, documentTfidf));
        }
        ArrayList<FrequencySearchResult> filteredTfidfResults = new ArrayList<FrequencySearchResult>();
        double largestTFIDF = 0.0;
        double smallestTFIDF = Integer.MAX_VALUE;
        for (FrequencySearchResult resultItem2 : unfilteredTfidfResults) {
            largestTFIDF = resultItem2.getFrequency() > largestTFIDF ? resultItem2.getFrequency() : largestTFIDF;
            smallestTFIDF = resultItem2.getFrequency() < smallestTFIDF ? resultItem2.getFrequency() : smallestTFIDF;
        }
        for (FrequencySearchResult resultItem : unfilteredTfidfResults) {
            double matchPercentage = Math.round((resultItem.getFrequency() - smallestTFIDF) / (largestTFIDF - smallestTFIDF) * (double)100);
            if (matchPercentage < (double)5 || Double.isNaN(matchPercentage)) continue;
            filteredTfidfResults.add(resultItem);
        }
        if (!filteredTfidfResults.isEmpty()) {
            return filteredTfidfResults;
        }
        for (Entry cachedComponent : contentCache.keySet()) {
            void $receiver$iv$iv;
            void $receiver$iv6;
            EntityPlayerSP entityPlayerSP = player;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerSP, (String)"player");
            if (!cachedComponent.isUnlocked((EntityPlayer)entityPlayerSP)) continue;
            String destination$iv$iv2 = contentCache.getOrDefault(cachedComponent, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.ROOT, (String)"Locale.ROOT");
            it22 = Locale.ROOT;
            String string11 = destination$iv$iv2;
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string12 = string11.toLowerCase((Locale)it22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.String).toLowerCase(locale)");
            String cachedDocument = StringsKt.replace$default((String)string12, (String)"'", (String)"", (boolean)false, (int)4, null);
            it22 = keywords;
            pattern2 = $receiver$iv6;
            Collection destination$iv$iv = new ArrayList(((void)$receiver$iv6).length);
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void it;
                void item$iv$iv = $receiver$iv$iv[i];
                String keywordDocumentOccurance = (String)item$iv$iv;
                object2 = destination$iv$iv;
                object = StringUtils.countMatches((CharSequence)cachedDocument, (CharSequence)((CharSequence)it));
                object2.add(object);
            }
            int mostMatches = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
            if (mostMatches <= 0) continue;
            matchCountSearchResults.add(new MatchCountSearchResult(cachedComponent, mostMatches));
        }
        return !matchCountSearchResults.isEmpty() ? (List)matchCountSearchResults : null;
    }

    public TFIDFSearch(@NotNull IBookGui book) {
        Intrinsics.checkParameterIsNotNull((Object)book, (String)"book");
        this.book = book;
    }

    @Override
    @NotNull
    public Function1<String, Unit> textBoxConsumer(@NotNull IBookGui book, @NotNull Function1<? super List<? extends ISearchAlgorithm.Result>, ? extends IBookElement> newComponent) {
        Intrinsics.checkParameterIsNotNull((Object)book, (String)"book");
        Intrinsics.checkParameterIsNotNull(newComponent, (String)"newComponent");
        return ISearchAlgorithm.DefaultImpls.textBoxConsumer(this, book, newComponent);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/TFIDFSearch$FrequencySearchResult;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/ISearchAlgorithm$Result;", "entry", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "frequency", "", "(Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;D)V", "getEntry", "()Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "getFrequency", "()D", "isSpecificResult", "", "()Z", "librarianlib-1.12.2"})
    public static final class FrequencySearchResult
    implements ISearchAlgorithm.Result {
        @NotNull
        private final Entry entry;
        private final double frequency;

        @Override
        public boolean isSpecificResult() {
            return true;
        }

        @Override
        @NotNull
        public Entry getEntry() {
            return this.entry;
        }

        @Override
        public double getFrequency() {
            return this.frequency;
        }

        public FrequencySearchResult(@NotNull Entry entry, double frequency) {
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
            this.entry = entry;
            this.frequency = frequency;
        }

        @Override
        public int compareTo(@NotNull ISearchAlgorithm.Result other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return ISearchAlgorithm.Result.DefaultImpls.compareTo(this, other);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/TFIDFSearch$MatchCountSearchResult;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/ISearchAlgorithm$Result;", "entry", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "nbOfMatches", "", "(Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;I)V", "getEntry", "()Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "frequency", "", "getFrequency", "()D", "isSpecificResult", "", "()Z", "librarianlib-1.12.2"})
    public static final class MatchCountSearchResult
    implements ISearchAlgorithm.Result {
        @NotNull
        private final Entry entry;
        private final int nbOfMatches;

        @Override
        public boolean isSpecificResult() {
            return false;
        }

        @Override
        public double getFrequency() {
            return this.nbOfMatches;
        }

        @Override
        @NotNull
        public Entry getEntry() {
            return this.entry;
        }

        public MatchCountSearchResult(@NotNull Entry entry, int nbOfMatches) {
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
            this.entry = entry;
            this.nbOfMatches = nbOfMatches;
        }

        @Override
        public int compareTo(@NotNull ISearchAlgorithm.Result other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return ISearchAlgorithm.Result.DefaultImpls.compareTo(this, other);
        }
    }
}

