/*
 * Decompiled with CFR 0.152.
 */
package one.flexo.nibbler.util;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public final class NibblerUtil {
    public static boolean notnull(WeakReference<?> weakRef) {
        return weakRef != null && weakRef.get() != null;
    }

    public static <V> V nnod(V value, V defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static <O, V> V nnod(O value, Function<O, V> function, V defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        V functionValue = function.apply(value);
        if (functionValue == null) {
            return defaultValue;
        }
        return functionValue;
    }

    public static final class Entity {
        private Entity() {
        }

        public static float getYaw(EnumFacing currentFacing) {
            switch (currentFacing) {
                default: {
                    return 0.0f;
                }
                case WEST: {
                    return 90.0f;
                }
                case NORTH: {
                    return 180.0f;
                }
                case EAST: 
            }
            return 270.0f;
        }

        public static EnumFacing getFacing(float yaw) {
            if ((yaw %= 360.0f) < 0.0f) {
                yaw += 360.0f;
            }
            yaw += 45.0f;
            return EnumFacing.func_176731_b((int)((int)(yaw %= 360.0f) / 90));
        }

        public static float getAttackDamage(ItemStack mainHand, EntityLivingBase entity) {
            IAttributeInstance dmgAttr = new AttributeMap().func_111150_b(SharedMonsterAttributes.field_111264_e);
            if (!mainHand.func_190926_b()) {
                Collection modifiers = mainHand.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
                for (AttributeModifier modifier : modifiers) {
                    dmgAttr.func_111121_a(modifier);
                }
            }
            float damage = (float)dmgAttr.func_111126_e();
            float enchantDamage = EnchantmentHelper.func_152377_a((ItemStack)mainHand, (EnumCreatureAttribute)entity.func_70668_bt());
            return damage + enchantDamage;
        }
    }

    public static final class Inventory {
        private Inventory() {
        }

        @SafeVarargs
        public static <T> NonNullList<T> asNonnullList(T ... array) {
            NonNullList nonNullList = NonNullList.func_191196_a();
            if (array != null) {
                nonNullList.addAll((Collection)Arrays.stream(array).filter(e -> e != null).collect(Collectors.toList()));
            }
            return nonNullList;
        }

        public static <T> NonNullList<T> asNonnullList(List<T> list) {
            NonNullList nonNullList = NonNullList.func_191196_a();
            if (list != null) {
                nonNullList.addAll((Collection)list.stream().filter(e -> e != null).collect(Collectors.toList()));
            }
            return nonNullList;
        }
    }

    public static final class Math {
        private Math() {
        }

        public static int clamp(int value, int min, int max) {
            return value < min ? min : (value > max ? max : value);
        }

        public static float clamp(float value, float min, float max) {
            return value < min ? min : (value > max ? max : value);
        }

        public static double clamp(double value, double min, double max) {
            return value < min ? min : (value > max ? max : value);
        }
    }
}

