/*
 * Decompiled with CFR 0.152.
 */
package one.flexo.nibbler.registry;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import one.flexo.nibbler.INibble;
import one.flexo.nibbler.item.NibblerBlockItem;
import one.flexo.nibbler.registry.TileEntityRegisteredBlocked;

@Mod.EventBusSubscriber
public class NibblerRegistry {
    private ArrayList<Block> blocks = new ArrayList();
    private ArrayList<Block> blockItems = new ArrayList();
    private ArrayList<Item> items = new ArrayList();

    public <B extends Block> void addBlockForRegistry(B block, boolean addItem) {
        this.blocks.add(block);
        if (addItem) {
            this.blockItems.add(block);
        }
    }

    public <I extends Item> void addItemForRegistry(I item) {
        this.items.add(item);
    }

    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (int i = 0; i < this.blocks.size(); ++i) {
            registry.register((IForgeRegistryEntry)this.blocks.get(i));
        }
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        int i;
        IForgeRegistry registry = event.getRegistry();
        for (i = 0; i < this.items.size(); ++i) {
            registry.register((IForgeRegistryEntry)this.items.get(i));
        }
        for (i = 0; i < this.blockItems.size(); ++i) {
            registry.register((IForgeRegistryEntry)new NibblerBlockItem((Block)((INibble)this.blockItems.get(i))));
        }
        for (i = 0; i < this.blocks.size(); ++i) {
            Block block = this.blocks.get(i);
            if (!(block instanceof TileEntityRegisteredBlocked)) continue;
            NibblerRegistry.registerTile(((TileEntityRegisteredBlocked)block).getTileEntityClass(), block);
        }
    }

    public static void registerTile(Class<? extends TileEntity> theClass, Block block) {
        GameRegistry.registerTileEntity(theClass, (String)block.getRegistryName().toString());
    }
}

