/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.net;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import quaternary.incorporeal.net.IncorporeticPacketHandler;
import vazkii.botania.common.Botania;

public class MessageSparkleLine
implements IncorporeticPacketHandler.IIncorporeticMessage {
    private Vec3d point1;
    private Vec3d point2;
    private int decay;

    public MessageSparkleLine() {
    }

    public MessageSparkleLine(Vec3d point1, Vec3d point2, int decay) {
        this.point1 = point1;
        this.point2 = point2;
        this.decay = decay;
    }

    public MessageSparkleLine(Vec3i point1, Vec3i point2, int decay) {
        this.point1 = new Vec3d(point1).func_72441_c(0.5, 0.5, 0.5);
        this.point2 = new Vec3d(point2).func_72441_c(0.5, 0.5, 0.5);
        this.decay = decay;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.point1.field_72450_a);
        buf.writeDouble(this.point1.field_72448_b);
        buf.writeDouble(this.point1.field_72449_c);
        buf.writeDouble(this.point2.field_72450_a);
        buf.writeDouble(this.point2.field_72448_b);
        buf.writeDouble(this.point2.field_72449_c);
        buf.writeInt(this.decay);
    }

    public void fromBytes(ByteBuf buf) {
        this.point1 = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.point2 = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.decay = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<MessageSparkleLine, IMessage> {
        public IMessage onMessage(MessageSparkleLine message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Vec3d diff = message.point2.func_178788_d(message.point1);
                Vec3d movement = diff.func_72432_b().func_186678_a(0.2);
                int iters = (int)(diff.func_72433_c() / movement.func_72433_c());
                float huePer = 1.0f / (float)iters;
                float hueSum = (float)Math.random();
                Vec3d currentPos = message.point1;
                Botania.proxy.setSparkleFXNoClip(true);
                for (int i = 0; i < iters; ++i) {
                    float hue = (float)i * huePer + hueSum;
                    Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
                    float r = Math.min(1.0f, (float)color.getRed() / 255.0f + 0.4f);
                    float g = Math.min(1.0f, (float)color.getGreen() / 255.0f + 0.4f);
                    float b = Math.min(1.0f, (float)color.getBlue() / 255.0f + 0.4f);
                    Botania.proxy.sparkleFX(currentPos.field_72450_a, currentPos.field_72448_b, currentPos.field_72449_c, r, g, b, 1.0f, message.decay);
                    currentPos = currentPos.func_178787_e(movement);
                }
                Botania.proxy.setSparkleFXNoClip(false);
            });
            return null;
        }
    }
}

