/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.item.cygnus;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.Incorporeal;
import quaternary.incorporeal.api.ISimpleRegistry;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public abstract class ItemCygnusCard<T>
extends Item {
    public final ISimpleRegistry<T> registry;
    public final String tagName;
    public final String tagNameLower;
    public final T defaultValue;

    public ItemCygnusCard(ISimpleRegistry<T> registry, String tagName, T defaultValue) {
        this.registry = registry;
        this.tagName = tagName;
        this.tagNameLower = tagName.toLowerCase(Locale.ROOT);
        this.defaultValue = defaultValue;
    }

    public T readValue(ItemStack stack) {
        T thing = this.registry.get(this.readValueName(stack));
        if (thing == null) {
            return this.defaultValue;
        }
        return thing;
    }

    public ResourceLocation readValueName(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return this.registry.nameOf(this.defaultValue);
        }
        String s = nbt.func_74779_i(this.tagName);
        if (s.isEmpty()) {
            return this.registry.nameOf(this.defaultValue);
        }
        return new ResourceLocation(s);
    }

    public String langKeyForValue(ItemStack stack) {
        ResourceLocation thingName = this.readValueName(stack);
        return thingName.func_110624_b() + ".cygnus." + this.tagNameLower + "." + thingName.func_110623_a();
    }

    public ItemStack set(ItemStack stack, T thing) {
        ItemNBTHelper.setString((ItemStack)stack, (String)this.tagName, (String)this.registry.nameOf(thing).toString());
        return stack;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == Incorporeal.TAB) {
            for (T thing : this.registry.allValues()) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a(this.tagName, this.registry.nameOf(thing).toString());
                ItemStack stack = new ItemStack((Item)this);
                stack.func_77982_d(nbt);
                items.add((Object)stack);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        String mainName = stack.func_77973_b().func_77667_c(stack) + ".name";
        String valueName = I18n.func_74838_a((String)this.langKeyForValue(stack));
        return I18n.func_74837_a((String)mainName, (Object[])new Object[]{valueName});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag mistake) {
        NBTTagCompound nbt;
        String uwu;
        if (mistake.func_194127_a() && stack.func_77942_o() && !(uwu = (nbt = stack.func_77978_p()).func_74779_i(this.tagName)).isEmpty()) {
            tooltip.add(nbt.func_74779_i(this.tagName));
        }
    }
}

