/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.item;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.ItemHandlerHelper;
import quaternary.incorporeal.item.ItemCorporeaTicket;
import quaternary.incorporeal.lexicon.IncorporeticLexicon;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;

@Mod.EventBusSubscriber
public class ItemTicketConjurer
extends Item
implements ILexiconable {
    private static final Map<Pattern, TileCorporeaIndex.IRegexStacker> patterns = (Map)ReflectionHelper.getPrivateValue(TileCorporeaIndex.class, null, (String[])new String[]{"patterns"});

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onChat(ServerChatEvent e) {
        ItemStack thisOrderStack;
        EntityPlayerMP player = e.getPlayer();
        if (player.func_184614_ca().func_77973_b() instanceof ItemTicketConjurer) {
            thisOrderStack = player.func_184592_cb();
        } else if (player.func_184592_cb().func_77973_b() instanceof ItemTicketConjurer) {
            thisOrderStack = player.func_184614_ca();
        } else {
            return;
        }
        String chatMessage = e.getMessage().toLowerCase().trim();
        String itemName = "";
        int itemCount = 0;
        boolean foundMatch = false;
        for (Map.Entry<Pattern, TileCorporeaIndex.IRegexStacker> pair : patterns.entrySet()) {
            Pattern pattern = pair.getKey();
            Matcher matcher = pattern.matcher(chatMessage);
            if (!matcher.matches()) continue;
            TileCorporeaIndex.IRegexStacker stacker = pair.getValue();
            itemCount = stacker.getCount(matcher);
            itemName = stacker.getName(matcher);
            foundMatch = true;
        }
        if ((itemName = itemName.toLowerCase().trim()).equals("this") || itemName.equals("these")) {
            if (thisOrderStack.func_190926_b()) {
                foundMatch = false;
            } else {
                itemName = thisOrderStack.func_82833_r();
            }
        }
        if (foundMatch) {
            ItemStack ticket = ItemCorporeaTicket.createFromRequest(itemName, itemCount);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)ticket);
            e.setCanceled(true);
        }
    }

    public LexiconEntry getEntry(World world, BlockPos blockPos, EntityPlayer entityPlayer, ItemStack itemStack) {
        return IncorporeticLexicon.ticketConjurer;
    }
}

