/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.flower;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import quaternary.incorporeal.IncorporeticConfig;
import quaternary.incorporeal.etc.helper.CorporeaHelper2;
import quaternary.incorporeal.item.ItemCorporeaTicket;
import quaternary.incorporeal.lexicon.IncorporeticLexicon;
import quaternary.incorporeal.net.IncorporeticPacketHandler;
import quaternary.incorporeal.net.MessageSparkleLine;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;

public class SubTileSanvocalia
extends SubTileFunctional
implements ILexiconable {
    @Nullable
    private UUID owner;
    private String customName = "Sanvocalia";
    private int cooldown;

    public void onUpdate() {
        super.onUpdate();
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        World w = this.supertile.func_145831_w();
        BlockPos pos = this.supertile.func_174877_v();
        if (w.field_72995_K || this.redstoneSignal > 0) {
            return;
        }
        AxisAlignedBB itemDetectionBox = new AxisAlignedBB(pos.func_177982_a(-this.getRange(), 0, -this.getRange()), pos.func_177982_a(this.getRange() + 1, 1, this.getRange() + 1));
        List nearbyTickets = w.func_175647_a(EntityItem.class, itemDetectionBox, ent -> {
            if (ent == null) {
                return false;
            }
            ItemStack stack = ent.func_92059_d();
            return ItemCorporeaTicket.hasRequest(stack);
        });
        if (nearbyTickets.isEmpty()) {
            return;
        }
        EntityItem ticket = (EntityItem)nearbyTickets.get(w.field_73012_v.nextInt(nearbyTickets.size()));
        CorporeaRequest ticketsRequest = ItemCorporeaTicket.getRequest(ticket.func_92059_d());
        assert (ticketsRequest != null);
        List<TileCorporeaIndex> nearbyIndices = CorporeaHelper2.getNearbyIndicesReflect(w, pos, this.getRange());
        if (nearbyIndices.isEmpty()) {
            MinecraftServer server = w.func_73046_m();
            if (server != null && this.mana >= 100) {
                TextComponentTranslation txt = new TextComponentTranslation("chat.type.text", new Object[]{this.customName, CorporeaHelper2.requestToString(ticketsRequest)});
                for (EntityPlayerMP player : w.func_73046_m().func_184103_al().func_181057_v()) {
                    if (!IncorporeticConfig.Sanvocalia.EVERYONE_HEARS_MESSAGES && !player.func_110124_au().equals(this.owner)) continue;
                    player.func_145747_a((ITextComponent)txt);
                }
                this.mana -= 100;
                this.consumeTicket(ticket, null);
                this.sync();
            }
        } else {
            boolean did = false;
            HashSet<BlockPos> indexPositions = new HashSet<BlockPos>();
            for (TileCorporeaIndex index : nearbyIndices) {
                if (this.mana < 20) break;
                CorporeaHelper2.spawnRequest(w, ticketsRequest, index.getSpark(), index.func_174877_v());
                this.mana -= 20;
                indexPositions.add(index.func_174877_v());
                did = true;
            }
            if (did) {
                this.consumeTicket(ticket, indexPositions);
                this.sync();
            }
        }
    }

    private void consumeTicket(EntityItem ticket, @Nullable Collection<BlockPos> indexPositions) {
        Vec3d ticketPos = ticket.func_174791_d();
        ItemStack ticketStack = ticket.func_92059_d();
        WorldServer world = (WorldServer)this.getWorld();
        BlockPos pos = this.getPos();
        IncorporeticPacketHandler.sendToAllTracking(new MessageSparkleLine(ticketPos, new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), 12), (World)world, pos);
        if (indexPositions != null) {
            for (BlockPos p : indexPositions) {
                IncorporeticPacketHandler.sendToAllTracking(new MessageSparkleLine(new Vec3d((Vec3i)p).func_72441_c(0.5, 0.5, 0.5), ticketPos, 12), (World)world, pos);
            }
        }
        SoundEvent sound = world.field_73012_v.nextDouble() < 0.1 ? SoundEvents.field_187739_dZ : SoundEvents.field_187537_bA;
        world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 0.5f, 1.0f);
        world.func_180505_a(EnumParticleTypes.ITEM_CRACK, false, ticket.field_70165_t, ticket.field_70163_u, ticket.field_70161_v, 20, 0.1, 0.1, 0.1, 0.05, new int[]{Item.func_150891_b((Item)ticketStack.func_77973_b()), ticketStack.func_77952_i()});
        if (ticketStack.func_190916_E() > 1) {
            ticketStack.func_190918_g(1);
            ticket.func_92058_a(ticketStack);
        } else {
            ticket.func_70106_y();
        }
        this.cooldown = 3;
    }

    public int getRange() {
        return 3;
    }

    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.supertile.func_174877_v(), this.getRange());
    }

    public int getMaxMana() {
        return 200;
    }

    public int getColor() {
        return 15570469;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        this.owner = entity != null ? entity.func_110124_au() : null;
        if (stack.func_82837_s()) {
            this.customName = stack.func_82833_r();
        }
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.owner = cmp.func_74764_b("Owner") ? NBTUtil.func_186860_b((NBTTagCompound)cmp.func_74775_l("Owner")) : null;
        this.customName = cmp.func_74779_i("CustomName");
        this.cooldown = cmp.func_74762_e("TicketCooldown");
    }

    public void writeToPacketNBT(NBTTagCompound cmp) {
        if (this.owner != null) {
            cmp.func_74782_a("Owner", (NBTBase)NBTUtil.func_186862_a((UUID)this.owner));
        }
        cmp.func_74778_a("CustomName", this.customName);
        cmp.func_74768_a("TicketCooldown", this.cooldown);
        super.writeToPacketNBT(cmp);
    }

    public LexiconEntry getEntry(World world, BlockPos blockPos, EntityPlayer entityPlayer, ItemStack itemStack) {
        return IncorporeticLexicon.sanvocalia;
    }

    public static class Mini
    extends SubTileSanvocalia {
        @Override
        public int getRange() {
            return 1;
        }
    }
}

