/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.etc.helper;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import quaternary.incorporeal.api.cygnus.ICygnusSparkable;
import quaternary.incorporeal.entity.cygnus.AbstractEntityCygnusSparkBase;
import quaternary.incorporeal.entity.cygnus.EntityCygnusMasterSpark;
import quaternary.incorporeal.entity.cygnus.EntityCygnusRegularSpark;

public final class CygnusHelpers {
    private CygnusHelpers() {
    }

    public static boolean isSparkable(World world, BlockPos pos, boolean master) {
        if (master) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof ICygnusSparkable) {
            return ((ICygnusSparkable)state.func_177230_c()).acceptsCygnusSpark(world, state, pos);
        }
        return false;
    }

    public static void spawnSparkAt(World world, BlockPos pos, boolean master) {
        AbstractEntityCygnusSparkBase spork = master ? new EntityCygnusMasterSpark(world) : new EntityCygnusRegularSpark(world);
        spork.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)spork);
    }

    @Nullable
    public static AbstractEntityCygnusSparkBase getSparkAt(World world, BlockPos pos) {
        List sporks = world.func_72872_a(AbstractEntityCygnusSparkBase.class, new AxisAlignedBB(pos.func_177984_a()));
        return sporks.isEmpty() ? null : (AbstractEntityCygnusSparkBase)((Object)sporks.get(0));
    }

    public static boolean isSparked(World world, BlockPos pos) {
        return CygnusHelpers.getSparkAt(world, pos) != null;
    }

    public static EntityCygnusMasterSpark getMasterSparkForSparkAt(World world, BlockPos pos) {
        AbstractEntityCygnusSparkBase spork = CygnusHelpers.getSparkAt(world, pos);
        return spork == null ? null : spork.getMasterSpark();
    }
}

