/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.etc;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import quaternary.incorporeal.api.ISimpleRegistry;

public class SimpleRegistry<T>
implements ISimpleRegistry<T> {
    BiMap<ResourceLocation, T> registry = HashBiMap.create();
    boolean frozen = false;

    @Override
    public void register(ResourceLocation name, T item) {
        if (this.frozen) {
            throw new IllegalStateException("Too late, this registry is frozen");
        }
        this.registry.put((Object)name, item);
    }

    @Override
    public T get(ResourceLocation name) {
        return (T)this.registry.get((Object)name);
    }

    @Override
    public ResourceLocation nameOf(T item) {
        return (ResourceLocation)this.registry.inverse().get(item);
    }

    @Override
    public Set<ResourceLocation> allKeys() {
        return this.registry.keySet();
    }

    @Override
    public Set<T> allValues() {
        return this.registry.values();
    }

    @Override
    public BiMap<ResourceLocation, T> backingMap() {
        return this.registry;
    }

    public void freeze() {
        this.frozen = true;
    }
}

