/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.etc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.integration.corporea.WrappedInventoryBase;

public class LyingWrappedInventory
extends WrappedInventoryBase {
    private final InvWithLocation inv;
    private final List<ItemStack> spoofedStacks;

    public LyingWrappedInventory(InvWithLocation inv, ICorporeaSpark spark, List<ItemStack> spoofedStacks) {
        super(spark);
        this.inv = inv;
        this.spoofedStacks = spoofedStacks;
    }

    public InvWithLocation getWrappedObject() {
        return this.inv;
    }

    public List<ItemStack> countItems(CorporeaRequest request) {
        return this.doMockedRequest(request);
    }

    public List<ItemStack> extractItems(CorporeaRequest request) {
        return this.doRealRequest(request);
    }

    private List<ItemStack> doMockedRequest(CorporeaRequest req) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack spoof : this.spoofedStacks) {
            if (!this.isMatchingItemStack(req.matcher, req.checkNBT, spoof)) continue;
            for (int i = 0; i < this.inv.handler.getSlots(); ++i) {
                ItemStack stackAt = this.inv.handler.getStackInSlot(i);
                if (stackAt.func_190926_b()) continue;
                ItemStack copy = new ItemStack(spoof.func_77973_b(), stackAt.func_190916_E(), spoof.func_77960_j());
                req.extractedItems = req.extractedItems + Math.min(stackAt.func_190916_E(), req.count == -1 ? stackAt.func_190916_E() : req.count);
                req.foundItems += copy.func_190916_E();
                stacks.add(copy);
            }
        }
        return stacks;
    }

    private List<ItemStack> doRealRequest(CorporeaRequest req) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack spoof : this.spoofedStacks) {
            if (!this.isMatchingItemStack(req.matcher, req.checkNBT, spoof)) continue;
            for (int i = this.inv.handler.getSlots() - 1; i >= 0; --i) {
                ItemStack stackAt = this.inv.handler.getStackInSlot(i);
                int rem = Math.min(stackAt.func_190916_E(), req.count == -1 ? stackAt.func_190916_E() : req.count);
                req.foundItems += stackAt.func_190916_E();
                if (rem > 0) {
                    stacks.add(this.inv.handler.extractItem(i, rem, false));
                    if (this.spark != null) {
                        this.spark.onItemExtracted(stackAt);
                    }
                }
                req.extractedItems += rem;
                if (req.count == -1) continue;
                req.count -= rem;
            }
        }
        return stacks;
    }
}

