/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.entity.cygnus;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import quaternary.incorporeal.entity.cygnus.AbstractEntityCygnusSparkBase;
import quaternary.incorporeal.entity.cygnus.EntityCygnusMasterSpark;
import quaternary.incorporeal.etc.helper.CygnusHelpers;
import quaternary.incorporeal.item.cygnus.IncorporeticCygnusItems;
import vazkii.botania.common.entity.EntitySpark;

public class EntityCygnusRegularSpark
extends AbstractEntityCygnusSparkBase {
    @Nullable
    EntityCygnusMasterSpark knownMaster;
    @Nullable
    AbstractEntityCygnusSparkBase uplinkToMaster;

    public EntityCygnusRegularSpark(World world) {
        super(world);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70170_p.func_82737_E() % 20L != 0L) {
            return;
        }
        if (this.knownMaster == null) {
            List<AbstractEntityCygnusSparkBase> nearbySparks = this.findNearbyMatchingTintSparks();
            for (AbstractEntityCygnusSparkBase spark : nearbySparks) {
                if (!(spark instanceof EntityCygnusMasterSpark)) continue;
                this.knownMaster = (EntityCygnusMasterSpark)spark;
                this.uplinkToMaster = this.knownMaster;
                break;
            }
            if (this.knownMaster == null) {
                for (AbstractEntityCygnusSparkBase spark : nearbySparks) {
                    if (!(spark instanceof EntityCygnusRegularSpark)) continue;
                    EntityCygnusRegularSpark regularSpark = (EntityCygnusRegularSpark)spark;
                    if (regularSpark.knownMaster == null) continue;
                    this.knownMaster = regularSpark.knownMaster;
                    this.uplinkToMaster = regularSpark;
                    break;
                }
            }
        } else if (this.knownMaster.field_70128_L || !this.field_70170_p.field_72996_f.contains(this.knownMaster)) {
            this.clearMaster();
        } else if (this.uplinkToMaster != null && this.knownMaster != this.uplinkToMaster) {
            AbstractEntityCygnusSparkBase uplink = this.uplinkToMaster;
            HashSet<AbstractEntityCygnusSparkBase> visitedSparks = new HashSet<AbstractEntityCygnusSparkBase>();
            visitedSparks.add(this);
            boolean ok = false;
            while (uplink != null && !visitedSparks.contains((Object)uplink)) {
                visitedSparks.add(uplink);
                if (uplink instanceof EntityCygnusMasterSpark) {
                    ok = true;
                    break;
                }
                if (uplink instanceof EntityCygnusRegularSpark) {
                    uplink = ((EntityCygnusRegularSpark)uplink).uplinkToMaster;
                    continue;
                }
                throw new RuntimeException("Found a spark that's not a master or nonmaster spark? wot?");
            }
            if (!ok) {
                this.clearMaster();
            }
        }
    }

    private void clearMaster() {
        this.knownMaster = null;
        this.uplinkToMaster = null;
    }

    @Override
    public void setTint(EnumDyeColor tint) {
        super.setTint(tint);
        this.clearMaster();
    }

    @Override
    protected boolean canStay() {
        return CygnusHelpers.isSparkable(this.field_70170_p, this.getAttachedPosition(), false);
    }

    @Override
    protected ItemStack getAssociatedItemStack() {
        return new ItemStack((Item)IncorporeticCygnusItems.CYGNUS_SPARK);
    }

    @Override
    protected void traceNetwork(EntityPlayer player) {
        if (this.uplinkToMaster == null) {
            return;
        }
        AbstractEntityCygnusSparkBase a = this;
        AbstractEntityCygnusSparkBase b = this.uplinkToMaster;
        while (true) {
            EntitySpark.particleBeam((EntityPlayer)player, (Entity)a, (Entity)b);
            a = b;
            if (!(b instanceof EntityCygnusRegularSpark)) break;
            b = ((EntityCygnusRegularSpark)b).uplinkToMaster;
        }
    }

    @Override
    public EntityCygnusMasterSpark getMasterSpark() {
        return this.knownMaster;
    }
}

