/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.entity.cygnus;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.api.cygnus.ICygnusFunnelable;
import quaternary.incorporeal.api.cygnus.ICygnusStack;
import quaternary.incorporeal.cygnus.CygnusStack;
import quaternary.incorporeal.cygnus.cap.IncorporeticCygnusCapabilities;
import quaternary.incorporeal.entity.cygnus.AbstractEntityCygnusSparkBase;
import quaternary.incorporeal.etc.CygnusStackDataSerializer;
import quaternary.incorporeal.etc.helper.CygnusHelpers;
import quaternary.incorporeal.item.cygnus.IncorporeticCygnusItems;

public class EntityCygnusMasterSpark
extends AbstractEntityCygnusSparkBase
implements ICygnusFunnelable {
    private static final DataParameter<CygnusStack> CYGNUS_STACK = EntityDataManager.func_187226_a(EntityCygnusMasterSpark.class, (DataSerializer)CygnusStackDataSerializer.INST);

    public EntityCygnusMasterSpark(World world) {
        super(world);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 2048.0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CYGNUS_STACK, (Object)new CygnusStack(16));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.getCygnusStack().isDirty()) {
            this.field_70180_af.func_187217_b(CYGNUS_STACK);
            this.getCygnusStack().clean();
        }
    }

    @Override
    protected boolean canStay() {
        return CygnusHelpers.isSparkable(this.field_70170_p, this.getAttachedPosition(), true);
    }

    @Override
    protected ItemStack getAssociatedItemStack() {
        return new ItemStack((Item)IncorporeticCygnusItems.MASTER_CYGNUS_SPARK);
    }

    @Override
    protected void traceNetwork(EntityPlayer player) {
    }

    @Override
    public EntityCygnusMasterSpark getMasterSpark() {
        return this;
    }

    public CygnusStack getCygnusStack() {
        return (CygnusStack)this.field_70180_af.func_187225_a(CYGNUS_STACK);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74782_a("Stack", (NBTBase)this.getCygnusStack().toNBT());
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.getCygnusStack().fromNBT(nbt.func_74775_l("Stack"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == IncorporeticCygnusCapabilities.FUNNEL_CAP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == IncorporeticCygnusCapabilities.FUNNEL_CAP) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean canGiveCygnusItem() {
        return true;
    }

    @Override
    public boolean canAcceptCygnusItem() {
        return true;
    }

    @Override
    @Nullable
    public Object giveItemToCygnus() {
        CygnusStack realStack = this.getCygnusStack();
        CygnusStack ret = realStack.copy();
        realStack.clear();
        return ret;
    }

    @Override
    public void acceptItemFromCygnus(Object item) {
        if (item instanceof ICygnusStack) {
            ICygnusStack newStack = (ICygnusStack)item;
            CygnusStack myStack = this.getCygnusStack();
            myStack.clear();
            for (int i = newStack.depth() - 1; i >= 0; --i) {
                newStack.peek(i).ifPresent(myStack::push);
            }
        }
    }
}

