/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.entity.cygnus;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import quaternary.incorporeal.entity.cygnus.EntityCygnusMasterSpark;
import quaternary.incorporeal.etc.EnumDyeColorDataSerializer;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.material.ItemDye;

public abstract class AbstractEntityCygnusSparkBase
extends Entity {
    public static final int SEARCH_RADIUS = 8;
    private static final DataParameter<EnumDyeColor> TINT = EntityDataManager.func_187226_a(AbstractEntityCygnusSparkBase.class, (DataSerializer)EnumDyeColorDataSerializer.INST);
    private static final DataParameter<Boolean> PHANTOM = EntityDataManager.func_187226_a(AbstractEntityCygnusSparkBase.class, (DataSerializer)DataSerializers.field_187198_h);

    protected abstract boolean canStay();

    protected abstract ItemStack getAssociatedItemStack();

    protected abstract void traceNetwork(EntityPlayer var1);

    public abstract EntityCygnusMasterSpark getMasterSpark();

    public AbstractEntityCygnusSparkBase(World world) {
        super(world);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.getAssociatedItemStack().func_77946_l();
    }

    protected void func_70088_a() {
        this.field_70178_ae = true;
        this.func_70105_a(0.2f, 0.5f);
        this.field_70180_af.func_187214_a(TINT, (Object)EnumDyeColor.WHITE);
        this.field_70180_af.func_187214_a(PHANTOM, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70165_t = (double)MathHelper.func_76128_c((double)this.field_70165_t) + 0.5;
            this.field_70163_u = (double)MathHelper.func_76128_c((double)this.field_70163_u) + 0.5;
            this.field_70161_v = (double)MathHelper.func_76128_c((double)this.field_70161_v) + 0.5;
            if (!this.canStay()) {
                this.drop();
            }
        }
    }

    public void drop() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70099_a(this.getAssociatedItemStack(), 0.0f);
            this.func_70106_y();
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        boolean ret = this.processInitialInteractInner(player, hand);
        if (ret) {
            player.func_184609_a(hand);
        }
        return ret;
    }

    protected boolean processInitialInteractInner(EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_77973_b() instanceof ItemTwigWand) {
            if (player.func_70093_af()) {
                this.drop();
            } else {
                this.traceNetwork(player);
            }
            return true;
        }
        if (held.func_77973_b() instanceof ItemDye) {
            EnumDyeColor dyeTint = EnumDyeColor.func_176764_b((int)held.func_77960_j());
            if (this.getTint() != dyeTint) {
                if (!player.func_184812_l_()) {
                    held.func_190918_g(1);
                }
                this.setTint(dyeTint);
                return true;
            }
        }
        if (held.func_77973_b() == ModItems.phantomInk) {
            this.setPhantomInked(true);
            return true;
        }
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public EnumDyeColor getTint() {
        return (EnumDyeColor)this.field_70180_af.func_187225_a(TINT);
    }

    public void setTint(EnumDyeColor tint) {
        this.field_70180_af.func_187227_b(TINT, (Object)tint);
        this.field_70180_af.func_187217_b(TINT);
    }

    public boolean isPhantomInked() {
        return (Boolean)this.field_70180_af.func_187225_a(PHANTOM);
    }

    public void setPhantomInked(boolean phantom) {
        this.field_70180_af.func_187227_b(PHANTOM, (Object)phantom);
        this.field_70180_af.func_187217_b(PHANTOM);
    }

    protected List<AbstractEntityCygnusSparkBase> findNearbyMatchingTintSparks() {
        AxisAlignedBB searchBox = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_186662_g(8.0);
        List neighbors = this.field_70170_p.func_72872_a(AbstractEntityCygnusSparkBase.class, searchBox);
        neighbors.removeIf(other -> other.getTint() != this.getTint());
        return neighbors;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Tint", this.getTint().func_176765_a());
        nbt.func_74757_a("Phantom", this.isPhantomInked());
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setTint(EnumDyeColor.func_176764_b((int)nbt.func_74762_e("Tint")));
        this.setPhantomInked(nbt.func_74767_n("Phantom"));
    }

    public BlockPos getAttachedPosition() {
        return this.func_180425_c().func_177979_c(2);
    }

    public IBlockState getAttachedState() {
        return this.field_70170_p.func_180495_p(this.getAttachedPosition());
    }
}

