/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import quaternary.incorporeal.etc.helper.EtcHelpers;
import quaternary.incorporeal.item.IncorporeticItems;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.core.helper.MathHelper;

public class EntityFracturedSpaceCollector
extends Entity {
    private BlockPos cratePos = BlockPos.field_177992_a;
    private static final DataParameter<Integer> DATA_AGE = EntityDataManager.func_187226_a(EntityFracturedSpaceCollector.class, (DataSerializer)DataSerializers.field_187192_b);
    private UUID ownerUUID;
    private static final double RADIUS = 2.0;
    private static final int MAX_AGE = 30;
    private static final float AGE_SPECIAL_START = 22.5f;
    private static final int PARTICLE_COUNT = 12;
    private static final int MANA_COST_PER_ITEM = 500;

    public EntityFracturedSpaceCollector(World world) {
        super(world);
    }

    public EntityFracturedSpaceCollector(World world, BlockPos cratePos, EntityPlayer player) {
        this(world);
        this.cratePos = cratePos;
        this.ownerUUID = player.func_110124_au();
    }

    protected void func_70088_a() {
        this.func_189654_d(true);
        this.func_184224_h(true);
        this.field_70178_ae = true;
        this.field_70130_N = 0.0f;
        this.field_70131_O = 0.0f;
        this.field_70180_af.func_187214_a(DATA_AGE, (Object)0);
    }

    public void func_70071_h_() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70071_h_();
        int age = (Integer)this.field_70180_af.func_187225_a(DATA_AGE);
        this.field_70180_af.func_187227_b(DATA_AGE, (Object)(++age));
        if (this.field_70170_p.field_72995_K && age <= 30) {
            double ageFraction = (double)age / 30.0;
            double radiusMult = 1.6 * (ageFraction - Math.pow(ageFraction, 7.0));
            double particleAngle = (double)age / 25.0;
            double height = radiusMult / 2.0;
            int i = 0;
            while (i < 12) {
                double x = Math.cos(particleAngle) * 2.0 * radiusMult;
                double z = Math.sin(particleAngle) * 2.0 * radiusMult;
                float size = (float)(1.0 + ageFraction * 5.0 * Math.random());
                Botania.proxy.sparkleFX(this.field_70165_t + x, this.field_70163_u + height, this.field_70161_v + z, 0.9f, 0.15f, 0.1f, size, 5);
                ++i;
                particleAngle += 0.5235987755982988;
            }
            double x = Math.cos(Math.random() * Math.PI * 2.0) * 2.0 * radiusMult;
            double z = Math.cos(Math.random() * Math.PI * 2.0) * 2.0 * radiusMult;
            Botania.proxy.wispFX(this.field_70165_t + x, this.field_70163_u - 0.5 + height, this.field_70161_v + z, 1.0f, 0.5f, 0.0f, 0.3f, -0.3f, 0.5f);
            if (age >= 28) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                for (int i2 = 0; i2 < 5; ++i2) {
                    Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.9f, 0.45f, 0.05f, 2.0f, -0.1f, 0.1f);
                }
            }
        } else if ((float)age > 22.5f) {
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t - 2.0, this.field_70163_u - 1.0, this.field_70161_v - 2.0, this.field_70165_t + 2.0, this.field_70163_u + 1.0, this.field_70161_v + 2.0);
            List nearbyItemEnts = this.field_70170_p.func_175647_a(EntityItem.class, aabb, ent -> ent != null && (double)MathHelper.pointDistancePlane((double)ent.field_70165_t, (double)ent.field_70161_v, (double)this.field_70165_t, (double)this.field_70161_v) <= 2.0);
            for (EntityItem ent2 : nearbyItemEnts) {
                double xDifference = this.field_70165_t - ent2.field_70165_t;
                double zDifference = this.field_70161_v - ent2.field_70161_v;
                ent2.field_70159_w += xDifference * 0.3;
                ent2.field_70179_y += zDifference * 0.3;
                ent2.field_70133_I = true;
            }
            if (age >= 30) {
                TileOpenCrate crate;
                if (this.ownerUUID == null) {
                    this.func_70106_y();
                    return;
                }
                EntityPlayer player = this.field_70170_p.func_152378_a(this.ownerUUID);
                if (player == null) {
                    this.func_70106_y();
                    return;
                }
                IBlockState state = this.field_70170_p.func_180495_p(this.cratePos);
                TileEntity tile = this.field_70170_p.func_175625_s(this.cratePos);
                if (tile != null && EtcHelpers.isOpenCrate(state, tile) && (crate = (TileOpenCrate)tile).canEject()) {
                    boolean redstone = false;
                    for (EnumFacing whichWay : EnumFacing.values()) {
                        if (this.field_70170_p.func_175651_c(this.cratePos.func_177972_a(whichWay), whichWay) == 0) continue;
                        redstone = true;
                        break;
                    }
                    ItemStack toolStack = new ItemStack((Item)IncorporeticItems.FRACTURED_SPACE_ROD);
                    for (EntityItem ent3 : nearbyItemEnts) {
                        ItemStack stack = ent3.func_92059_d();
                        int costForThisStack = 500 * stack.func_190916_E();
                        if (!ManaItemHandler.requestManaExact((ItemStack)toolStack, (EntityPlayer)player, (int)costForThisStack, (boolean)false)) continue;
                        ManaItemHandler.requestManaExact((ItemStack)toolStack, (EntityPlayer)player, (int)costForThisStack, (boolean)true);
                        crate.eject(stack, redstone);
                        ent3.func_70106_y();
                    }
                }
                this.func_70106_y();
            }
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.field_70180_af.func_187227_b(DATA_AGE, (Object)nbt.func_74762_e("Age"));
        this.cratePos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("CratePos"));
        this.ownerUUID = NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l("Owner"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Age", ((Integer)this.field_70180_af.func_187225_a(DATA_AGE)).intValue());
        nbt.func_74782_a("CratePos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.cratePos));
        nbt.func_74782_a("Owner", (NBTBase)NBTUtil.func_186862_a((UUID)this.ownerUUID));
    }

    public int func_82145_z() {
        return Integer.MAX_VALUE;
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }
}

