/*
 * Decompiled with CFR 0.152.
 */
package quaternary.incorporeal.cygnus.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.incorporeal.api.cygnus.ICygnusDatatype;
import quaternary.incorporeal.cygnus.CygnusDatatypeHelpers;
import quaternary.incorporeal.cygnus.CygnusStack;

public class CygnusStackType
implements ICygnusDatatype<CygnusStack> {
    @Override
    public Class<CygnusStack> getTypeClass() {
        return CygnusStack.class;
    }

    @Override
    public String getTranslationKey() {
        return "incorporeal.cygnus.type.stack";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> describe(CygnusStack thing) {
        ArrayList<String> desc = new ArrayList<String>(thing.depth());
        for (int i = 0; i < thing.depth(); ++i) {
            int displayedIndex = i + 1;
            thing.peek(i).ifPresent(entry -> {
                for (String entryDesc : CygnusDatatypeHelpers.forClass(entry.getClass()).describeUnchecked(entry)) {
                    desc.add("  " + displayedIndex + ": " + entryDesc);
                }
            });
        }
        return desc;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, CygnusStack item) {
        nbt.func_74782_a("Stack", (NBTBase)item.toNBT());
    }

    @Override
    public CygnusStack readFromNBT(NBTTagCompound nbt) {
        CygnusStack s = new CygnusStack(0);
        s.fromNBT(nbt.func_74775_l("Stack"));
        return s;
    }

    @Override
    public void writeToPacketBuffer(PacketBuffer buf, CygnusStack item) {
        item.toPacketBuffer(buf);
    }

    @Override
    public CygnusStack readFromPacketBuffer(PacketBuffer buf) {
        CygnusStack s = new CygnusStack(0);
        s.fromPacketBuffer(buf);
        return s;
    }

    @Override
    public boolean areEqual(CygnusStack item1, CygnusStack item2) {
        if (item1.maxDepth() != item2.maxDepth()) {
            return false;
        }
        if (item1.depth() != item2.depth()) {
            return false;
        }
        for (int i = 0; i < item1.depth(); ++i) {
            Optional<Object> a = item1.peek(i);
            Optional<Object> b = item2.peek(i);
            if (a.isPresent() && b.isPresent()) {
                Object oa = a.get();
                Object ob = b.get();
                if (oa.getClass() != ob.getClass()) {
                    return false;
                }
                if (CygnusDatatypeHelpers.forClass(oa.getClass()).areEqualUnchecked(oa, ob)) continue;
                return false;
            }
            if (a.isPresent() == b.isPresent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString(CygnusStack item) {
        StringBuilder b = new StringBuilder();
        b.append("Stack ").append(item.depth());
        for (int i = 0; i < item.depth(); ++i) {
            b.append(' ');
            item.peek(i).ifPresent(b::append);
        }
        return b.toString();
    }

    @Override
    public int toComparator(CygnusStack item) {
        return MathHelper.func_76125_a((int)item.depth(), (int)1, (int)15);
    }
}

